/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeHasNoContentException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.smb.SmbFileName;
import org.apache.commons.vfs2.provider.smb.SmbFileProvider;
import org.apache.commons.vfs2.provider.smb.SmbFileRandomAccessContent;
import org.apache.commons.vfs2.provider.smb.SmbFileSystem;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SmbFileObject
extends AbstractFileObject
implements FileObject {
    private SmbFile file;

    protected SmbFileObject(AbstractFileName name, SmbFileSystem fileSystem) throws FileSystemException {
        super(name, fileSystem);
    }

    @Override
    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = this.createSmbFile(this.getName());
        }
    }

    @Override
    protected void doDetach() throws Exception {
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbFile createSmbFile(FileName fileName) throws MalformedURLException, SmbException, FileSystemException {
        SmbFile file;
        NtlmPasswordAuthentication auth;
        SmbFileName smbFileName = (SmbFileName)fileName;
        String path = smbFileName.getUriWithoutAuth();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.getFileSystem().getFileSystemOptions(), SmbFileProvider.AUTHENTICATOR_TYPES);
            auth = new NtlmPasswordAuthentication(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.DOMAIN, UserAuthenticatorUtils.toChar(smbFileName.getDomain()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(smbFileName.getUserName()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(smbFileName.getPassword()))));
            file = new SmbFile(path, auth);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        if (file.isDirectory() && !file.toString().endsWith("/")) {
            file = new SmbFile(path + "/", auth);
        }
        return file;
    }

    @Override
    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.smb/get-type.error", (Object)this.getName());
    }

    @Override
    protected String[] doListChildren() throws Exception {
        if (!this.file.isDirectory()) {
            return null;
        }
        return UriParser.encode(this.file.list());
    }

    @Override
    protected boolean doIsHidden() throws Exception {
        return this.file.isHidden();
    }

    @Override
    protected void doDelete() throws Exception {
        this.file.delete();
    }

    @Override
    protected void doRename(FileObject newfile) throws Exception {
        this.file.renameTo(this.createSmbFile(newfile.getName()));
    }

    @Override
    protected void doCreateFolder() throws Exception {
        this.file.mkdir();
        this.file = this.createSmbFile(this.getName());
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getLastModified();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        try {
            return new SmbFileInputStream(this.file);
        }
        catch (SmbException e) {
            if (e.getNtStatus() == -1073741809 || e.getNtStatus() == -1073741810 || e.getNtStatus() == -1073741772) {
                throw new FileNotFoundException(this.getName());
            }
            if (this.file.isDirectory()) {
                throw new FileTypeHasNoContentException(this.getName());
            }
            throw e;
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new SmbFileOutputStream(this.file, bAppend);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SmbFileRandomAccessContent(this.file, mode);
    }
}

