/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;

public class LargeTarTestCase
extends TestCase {
    private static final String baseDir = "target/test-classes/test-data/";
    private DefaultFileSystemManager manager;
    private static final String largeFilePath = "target/test-classes/test-data/";
    private static final String largeFileName = "largefile";

    public void setUp() throws Exception {
        this.manager = new DefaultFileSystemManager();
        this.manager.setFilesCache(new SoftRefFilesCache());
        this.manager.setCacheStrategy(CacheStrategy.ON_RESOLVE);
        this.manager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        this.manager.addProvider("tgz", (FileProvider)new TarFileProvider());
        this.manager.addProvider("tar", (FileProvider)new TarFileProvider());
        new File("target/test-classes/test-data/").mkdir();
        this.createLargeFile("target/test-classes/test-data/", largeFileName);
    }

    public void testLargeFile() throws Exception {
        File realFile = new File("target/test-classes/test-data/largefile.tar.gz");
        FileObject file = this.manager.resolveFile("tgz:file://" + realFile.getCanonicalPath() + "!/");
        LargeTarTestCase.assertNotNull((Object)file);
        List<FileObject> files = Arrays.asList(file.getChildren());
        LargeTarTestCase.assertNotNull(files);
        LargeTarTestCase.assertEquals((int)1, (int)files.size());
        FileObject f = files.get(0);
        LargeTarTestCase.assertTrue((String)"Expected file not found: largefile.txt", (boolean)f.getName().getBaseName().equals("largefile.txt"));
    }

    protected void fileCheck(String[] expectedFiles, String tarFile) throws Exception {
        LargeTarTestCase.assertNotNull((Object)this.manager);
        FileObject file = this.manager.resolveFile(tarFile);
        LargeTarTestCase.assertNotNull((Object)file);
        List<FileObject> files = Arrays.asList(file.getChildren());
        LargeTarTestCase.assertNotNull(files);
        for (int i = 0; i < expectedFiles.length; ++i) {
            String expectedFile = expectedFiles[i];
            LargeTarTestCase.assertTrue((String)("Expected file not found: " + expectedFile), (boolean)this.fileExists(expectedFile, files));
        }
    }

    protected boolean fileExists(String expectedFile, List<FileObject> files) {
        for (FileObject file : files) {
            if (!file.getName().getBaseName().equals(expectedFile)) continue;
            return true;
        }
        return false;
    }

    protected boolean endsWith(String testString, String[] testList) {
        for (int i = 0; i < testList.length; ++i) {
            String testItem = testList[i];
            if (!testString.endsWith(testItem)) continue;
            return true;
        }
        return false;
    }

    protected void createLargeFile(String path, final String name) throws Exception {
        long _1K = 1024L;
        long _1M = 0x100000L;
        long _1G = 0x40000000L;
        long fileSize = 0xC0000000L;
        File tarGzFile = new File(path + name + ".tar.gz");
        if (!tarGzFile.exists()) {
            System.out.println("This test is a bit slow. It needs to write 3GB of data as a compressed file (approx. 3MB) to your hard drive");
            final PipedOutputStream outTarFileStream = new PipedOutputStream();
            PipedInputStream inTarFileStream = new PipedInputStream(outTarFileStream);
            Thread source = new Thread(){

                @Override
                public void run() {
                    byte[] ba_1k = new byte[1024];
                    for (int i = 0; i < ba_1k.length; ++i) {
                        ba_1k[i] = 97;
                    }
                    try {
                        TarArchiveOutputStream outTarStream = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", outTarFileStream);
                        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(name + ".txt");
                        tarArchiveEntry.setSize(0xC0000000L);
                        outTarStream.putArchiveEntry(tarArchiveEntry);
                        for (long i = 0L; i < 0xC0000000L; i += (long)ba_1k.length) {
                            outTarStream.write(ba_1k);
                        }
                        outTarStream.closeArchiveEntry();
                        outTarStream.close();
                        outTarFileStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            source.start();
            FileOutputStream outGzipFileStream = new FileOutputStream(path + name + ".tar.gz");
            GzipCompressorOutputStream outGzipStream = (GzipCompressorOutputStream)new CompressorStreamFactory().createCompressorOutputStream("gz", outGzipFileStream);
            IOUtils.copy(inTarFileStream, outGzipStream);
            inTarFileStream.close();
            outGzipStream.close();
            ((OutputStream)outGzipFileStream).close();
        }
    }
}

