/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar.test;

import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;

public class NestedTgzTestCase
extends AbstractProviderTestConfig
implements ProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new NestedTgzTestCase(), true);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("tgz", (FileProvider)new TarFileProvider());
        manager.addExtensionMap("tgz", "tgz");
        manager.addProvider("tar", (FileProvider)new TarFileProvider());
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String tarFilePath = AbstractVfsTestCase.getTestResource((String)"nested.tgz").getAbsolutePath();
        String uri = "tgz:file:" + tarFilePath + "!/test.tgz";
        FileObject tarFile = manager.resolveFile(uri);
        FileObject nestedFS = manager.createFileSystem(tarFile);
        return nestedFS.resolveFile("/");
    }
}

