/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav.test;

import junit.framework.Test;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.webdav.WebdavFileProvider;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.test.WebdavProviderTestSuite;
import org.apache.commons.vfs2.provider.webdav.test.WebdavVersioningTests;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;

public class WebdavProviderTestCase
extends AbstractProviderTestConfig {
    private static final String TEST_URI = "test.webdav.uri";

    public static Test suite() throws Exception {
        if (System.getProperty(TEST_URI) != null) {
            WebdavProviderTestSuite suite = new WebdavProviderTestSuite(new WebdavProviderTestCase());
            suite.addTests(WebdavVersioningTests.class);
            return suite;
        }
        return WebdavProviderTestCase.notConfigured(WebdavProviderTestCase.class);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("webdav", (FileProvider)new WebdavFileProvider());
        manager.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        WebdavFileSystemConfigBuilder builder = (WebdavFileSystemConfigBuilder)manager.getFileSystemConfigBuilder("webdav");
        String uri = System.getProperty(TEST_URI);
        FileSystemOptions opts = new FileSystemOptions();
        builder.setRootURI(opts, uri);
        return manager.resolveFile(uri, opts);
    }
}

