/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import junit.framework.AssertionFailedError;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class LastModifiedTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_LAST_MODIFIED};
    }

    public void testGetLastModified() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        file.getContent().getLastModifiedTime();
    }

    public void _testSetLastModified() throws Exception {
        long now = System.currentTimeMillis();
        if (this.getReadFolder().getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
            FileObject file = this.getReadFolder().resolveFile("file1.txt");
            file.getContent().setLastModifiedTime(now);
            try {
                LastModifiedTests.assertEquals((double)now, (double)file.getContent().getLastModifiedTime(), (double)file.getFileSystem().getLastModTimeAccuracy());
            }
            catch (AssertionFailedError e) {
                if (file.getFileSystem().getLastModTimeAccuracy() < 1000.0) {
                    LastModifiedTests.assertEquals((float)now, (float)file.getContent().getLastModifiedTime(), (float)1000.0f);
                }
                throw e;
            }
        }
        if (this.getReadFolder().getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) {
            FileObject folder = this.getReadFolder().resolveFile("dir1");
            folder.getContent().setLastModifiedTime(now);
            try {
                LastModifiedTests.assertEquals((double)now, (double)folder.getContent().getLastModifiedTime(), (double)folder.getFileSystem().getLastModTimeAccuracy());
            }
            catch (AssertionFailedError e) {
                if (folder.getFileSystem().getLastModTimeAccuracy() < 1000.0) {
                    LastModifiedTests.assertEquals((float)now, (float)folder.getContent().getLastModifiedTime(), (float)1000.0f);
                }
                throw e;
            }
        }
    }
}

