/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.VirtualFileSystem;
import org.apache.commons.vfs2.provider.ram.RamFileObject;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.util.FileObjectUtils;

public class ProviderCacheStrategyTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.CREATE, Capability.GET_TYPE, Capability.LIST_CHILDREN};
    }

    public void testManualCache() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        if (FileObjectUtils.isInstanceOf(this.getBaseFolder(), RamFileObject.class) || scratchFolder.getFileSystem() instanceof VirtualFileSystem) {
            return;
        }
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        DefaultFileSystemManager fs = this.createManager();
        fs.setCacheStrategy(CacheStrategy.MANUAL);
        fs.init();
        FileObject foBase2 = this.getBaseTestFolder(fs);
        FileObject cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        FileObject[] fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        scratchFolder.resolveFile("file1.txt").createFile();
        fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        cachedFolder.refresh();
        fos = cachedFolder.getChildren();
        this.assertContains(fos, "file1.txt");
    }

    public void testOnResolveCache() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        if (FileObjectUtils.isInstanceOf(this.getBaseFolder(), RamFileObject.class) || scratchFolder.getFileSystem() instanceof VirtualFileSystem) {
            return;
        }
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        DefaultFileSystemManager fs = this.createManager();
        fs.setCacheStrategy(CacheStrategy.ON_RESOLVE);
        fs.init();
        FileObject foBase2 = this.getBaseTestFolder(fs);
        FileObject cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        FileObject[] fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        scratchFolder.resolveFile("file1.txt").createFile();
        fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        fos = cachedFolder.getChildren();
        this.assertContains(fos, "file1.txt");
    }

    public void testOnCallCache() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        if (FileObjectUtils.isInstanceOf(this.getBaseFolder(), RamFileObject.class) || scratchFolder.getFileSystem() instanceof VirtualFileSystem) {
            return;
        }
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        DefaultFileSystemManager fs = this.createManager();
        fs.setCacheStrategy(CacheStrategy.ON_CALL);
        fs.init();
        FileObject foBase2 = this.getBaseTestFolder(fs);
        FileObject cachedFolder = foBase2.resolveFile(scratchFolder.getName().getPath());
        FileObject[] fos = cachedFolder.getChildren();
        this.assertContainsNot(fos, "file1.txt");
        scratchFolder.resolveFile("file1.txt").createFile();
        fos = cachedFolder.getChildren();
        this.assertContains(fos, "file1.txt");
    }

    public void assertContainsNot(FileObject[] fos, String string) {
        for (int i = 0; i < fos.length; ++i) {
            if (!string.equals(fos[i].getName().getBaseName())) continue;
            ProviderCacheStrategyTests.fail((String)(string + " should not be seen"));
        }
    }

    public void assertContains(FileObject[] fos, String string) {
        for (int i = 0; i < fos.length; ++i) {
            if (!string.equals(fos[i].getName().getBaseName())) continue;
            return;
        }
        ProviderCacheStrategyTests.fail((String)(string + " should be seen"));
    }
}

