/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.OutputStream;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class ProviderRenameTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT, Capability.RENAME};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenameFile() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderRenameTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        OutputStream os = file.getContent().getOutputStream();
        try {
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        finally {
            os.close();
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        FileObject fileMove = scratchFolder.resolveFile("file1move.txt");
        ProviderRenameTests.assertTrue((!fileMove.exists() ? 1 : 0) != 0);
        file.moveTo(fileMove);
        ProviderRenameTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        ProviderRenameTests.assertTrue((boolean)fileMove.exists());
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", fileMove);
        ProviderRenameTests.assertTrue((boolean)fileMove.exists());
        ProviderRenameTests.assertTrue((boolean)fileMove.delete());
    }
}

