/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.file;

import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.extension.io.file.FileHandler;
import io.siddhi.extension.io.file.util.Status;
import io.siddhi.extension.io.file.util.Util;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.log4j.Logger;

public class FileAlterationImpl
implements FileAlterationListener {
    private static final Logger log = Logger.getLogger(FileHandler.class);
    private Map<String, Long> fileObjectMap = new ConcurrentHashMap<String, Long>();
    private SourceEventListener sourceEventListener;
    private List<String> fileObjectList;
    private Status enumStatus;

    public FileAlterationImpl(SourceEventListener sourceEventListener, List<String> fileObjectList) {
        this.sourceEventListener = sourceEventListener;
        this.fileObjectList = fileObjectList;
    }

    public void onStart(FileAlterationObserver observer) {
    }

    public void onDirectoryCreate(File directory) {
        log.debug((Object)(directory.getAbsolutePath() + " was created."));
        this.fileObjectMap.put(directory.getAbsolutePath(), directory.length());
        this.sourceEventListener.onEvent((Object)Util.getFileHandlerEvent(directory, this.fileObjectList, Status.STATUS_NEW), null);
    }

    public void onDirectoryChange(File directory) {
        log.debug((Object)(directory.getAbsolutePath() + " was modified."));
        this.fileObjectMap.put(directory.getAbsolutePath(), directory.lastModified());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error occurred in Thread.sleep() ", (Throwable)e);
        }
        long recentModifiedTimestamp = this.fileObjectMap.get(directory.getAbsolutePath());
        if (recentModifiedTimestamp < directory.lastModified()) {
            this.enumStatus = Status.STATUS_PROCESS;
            this.fileObjectMap.put(directory.getAbsolutePath(), directory.lastModified());
        } else {
            this.enumStatus = Status.STATUS_DONE;
        }
        this.sourceEventListener.onEvent((Object)Util.getFileHandlerEvent(directory, this.fileObjectList, this.enumStatus), null);
    }

    public void onDirectoryDelete(File directory) {
        log.debug((Object)(directory.getAbsolutePath() + " was deleted."));
        this.fileObjectMap.remove(directory.getAbsolutePath());
        this.sourceEventListener.onEvent((Object)Util.getFileHandlerEvent(directory, this.fileObjectList, Status.STATUS_REMOVE), null);
    }

    public void onFileCreate(File file) {
        log.debug((Object)(file.getAbsolutePath() + " was created."));
        this.fileObjectMap.put(file.getAbsolutePath(), file.length());
        this.sourceEventListener.onEvent((Object)Util.getFileHandlerEvent(file, this.fileObjectList, Status.STATUS_NEW), null);
    }

    public void onFileChange(File file) {
        log.debug((Object)(file.getAbsolutePath() + " was modified."));
        this.fileObjectMap.put(file.getAbsolutePath(), file.lastModified());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error occurred in Thread.sleep() ", (Throwable)e);
        }
        long recentModifiedTimestamp = this.fileObjectMap.get(file.getAbsolutePath());
        if (recentModifiedTimestamp < file.lastModified()) {
            this.enumStatus = Status.STATUS_PROCESS;
            this.fileObjectMap.put(file.getAbsolutePath(), file.lastModified());
        } else {
            this.enumStatus = Status.STATUS_DONE;
        }
        this.sourceEventListener.onEvent((Object)Util.getFileHandlerEvent(file, this.fileObjectList, this.enumStatus), null);
    }

    public void onFileDelete(File file) {
        log.debug((Object)(file.getAbsolutePath() + " was deleted."));
        this.fileObjectMap.remove(file.getAbsolutePath());
        this.sourceEventListener.onEvent((Object)Util.getFileHandlerEvent(file, this.fileObjectList, Status.STATUS_REMOVE), null);
    }

    public void onStop(FileAlterationObserver observer) {
    }
}

