/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.file.metrics;

import io.siddhi.extension.io.file.metrics.FileDeleteMetrics;
import io.siddhi.extension.io.file.metrics.FileMoveMetrics;
import io.siddhi.extension.io.file.metrics.Metrics;
import io.siddhi.extension.io.file.metrics.StreamStatus;
import io.siddhi.extension.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Gauge;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

public class SourceMetrics
extends Metrics {
    private static final Logger log = Logger.getLogger(SourceMetrics.class);
    private final Map<String, StreamStatus> sourceFileStatusMap = new HashMap<String, StreamStatus>();
    private final Map<String, Long> lastConsumedTimeMap = new HashMap<String, Long>();
    private boolean isStarted;
    private String filePath;
    private String fileName;
    private final String readingMode;
    private final String streamName;
    private final FileDeleteMetrics fileDeleteMetrics;
    private final FileMoveMetrics fileMoveMetrics;
    private double readPercentage;

    public SourceMetrics(String siddhiAppName, String readingMode, String streamName) {
        super(siddhiAppName);
        this.readingMode = readingMode;
        this.streamName = streamName;
        this.fileDeleteMetrics = new FileDeleteMetrics(siddhiAppName);
        this.fileMoveMetrics = new FileMoveMetrics(siddhiAppName);
    }

    public Counter getTotalReadsMetrics() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Total.Reads.%s", this.siddhiAppName, "file"), Level.INFO, new Level[0]);
    }

    public Counter getTotalFileReadCount() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.Total.Reads.%s.%s.%s.%s", this.siddhiAppName, this.fileName + ".filename", this.readingMode, this.streamName, this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getReadByteMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "total_read_byte", this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getValidEventCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "total_valid_events_count", this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getReadLineCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "lines_count", this.filePath), Level.INFO, new Level[0]);
    }

    public void getElapseTimeMetric(Gauge gauge) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "elapse_time", this.filePath), Level.INFO, gauge);
    }

    public Counter getTotalErrorCount() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "error_count", this.filePath), Level.INFO, new Level[0]);
    }

    public void getFileSizeMetric(Gauge gauge) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "file_size", this.filePath), Level.INFO, gauge);
    }

    public void getFileStatusMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "file_status", this.filePath), Level.INFO, (Gauge)new FileStatusGauge(this.filePath));
    }

    public void getStartedTimeMetric(long startTime) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "started_time", this.filePath), Level.INFO, () -> startTime);
    }

    public void getCompletedTimeMetric(long completedTime) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "completed_time", this.filePath), Level.INFO, () -> completedTime);
    }

    public void getTailEnabledMetric(int enable) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "tailing_enable", this.filePath), Level.INFO, () -> enable);
    }

    public void getReadPercentageMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Source.%s.%s", this.siddhiAppName, "read_percentage", this.filePath), Level.INFO, () -> this.readPercentage);
    }

    public void setFilePath(String fileURI) {
        this.filePath = Utils.getShortFilePath(fileURI);
        this.fileName = Utils.getFileName(fileURI, this);
        this.fileMoveMetrics.set_source(this.filePath);
        this.fileDeleteMetrics.setSource(this.filePath);
    }

    public void updateMetrics(ExecutorService executorService) {
        if (!this.isStarted) {
            executorService.execute(() -> {
                this.isStarted = true;
                while (this.isStarted) {
                    try {
                        if (!this.lastConsumedTimeMap.isEmpty()) {
                            this.lastConsumedTimeMap.forEach((filePath, lastModifiedTime) -> {
                                long idleTime = System.currentTimeMillis() - lastModifiedTime;
                                if (idleTime / 1000L >= 8L) {
                                    this.sourceFileStatusMap.replace((String)filePath, StreamStatus.IDLE);
                                }
                            });
                        }
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Error while updating the status of files.", (Throwable)e);
                    }
                }
            });
        }
    }

    public FileDeleteMetrics getFileDeleteMetrics() {
        return this.fileDeleteMetrics;
    }

    public FileMoveMetrics getFileMoveMetrics() {
        return this.fileMoveMetrics;
    }

    public Map<String, StreamStatus> getSourceFileStatusMap() {
        return this.sourceFileStatusMap;
    }

    public Map<String, Long> getTailEnabledFilesMap() {
        return this.lastConsumedTimeMap;
    }

    public void setReadPercentage(double readPercentage) {
        this.readPercentage = readPercentage;
    }

    private class FileStatusGauge
    implements Gauge<Integer> {
        private final String fileURI;

        private FileStatusGauge(String fileURI) {
            this.fileURI = fileURI;
        }

        public Integer getValue() {
            if (SourceMetrics.this.sourceFileStatusMap.containsKey(this.fileURI)) {
                return ((StreamStatus)((Object)SourceMetrics.this.sourceFileStatusMap.get(this.fileURI))).ordinal();
            }
            return 0;
        }
    }
}

