/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class FTPClientWrapper
implements FtpClient {
    private static final Log LOG = LogFactory.getLog(FTPClientWrapper.class);
    protected final FileSystemOptions fileSystemOptions;
    private final GenericFileName root;
    private FTPClient ftpClient;

    protected FTPClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient createClient() throws FileSystemException {
        char[] password;
        char[] username;
        UserAuthenticationData authData;
        Map<String, String> queryParams;
        GenericFileName rootName;
        block4: {
            FTPClient fTPClient;
            rootName = this.getRoot();
            queryParams = null;
            if (rootName instanceof URLFileName) {
                queryParams = this.getQueryParams((URLFileName)rootName);
            }
            authData = null;
            try {
                authData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpFileProvider.AUTHENTICATOR_TYPES);
                username = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName()));
                password = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()));
                if (queryParams != null) break block4;
                fTPClient = this.createClient(rootName, authData);
            }
            catch (Throwable throwable) {
                UserAuthenticatorUtils.cleanup(authData);
                throw throwable;
            }
            UserAuthenticatorUtils.cleanup(authData);
            return fTPClient;
        }
        FTPClient fTPClient = FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), username, password, rootName.getPath(), this.getFileSystemOptions(), queryParams.get("proxyServer"), queryParams.get("proxyPort"), queryParams.get("proxyUsername"), queryParams.get("proxyPassword"), queryParams.get("timeout"), queryParams.get("retryCount"));
        UserAuthenticatorUtils.cleanup(authData);
        return fTPClient;
    }

    private Map<String, String> getQueryParams(URLFileName urlFileName) {
        HashMap<String, String> mQueryParams = new HashMap<String, String>();
        String strQuery = urlFileName.getQueryString();
        if (strQuery != null && !strQuery.isEmpty()) {
            for (String strParam : strQuery.split("&")) {
                String[] arrParam = strParam.split("=");
                if (arrParam.length < 2) continue;
                mQueryParams.put(arrParam[0], arrParam[1]);
            }
        }
        return mQueryParams;
    }

    protected FTPClient createClient(GenericFileName rootName, UserAuthenticationData authData) throws FileSystemException {
        return FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), rootName.getPath(), this.getFileSystemOptions());
    }

    private FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    @Override
    public boolean isConnected() throws FileSystemException {
        return this.ftpClient != null && this.ftpClient.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().quit();
            return;
        }
        catch (IOException e) {
            LOG.debug((Object)"I/O exception while trying to quit, probably it's a timed out connection, ignoring.", (Throwable)e);
            return;
        }
        finally {
            try {
                this.getFtpClient().disconnect();
            }
            catch (IOException e) {
                LOG.warn((Object)"I/O exception while trying to disconnect, probably it's a closed connection, ignoring.", (Throwable)e);
            }
            finally {
                this.ftpClient = null;
            }
        }
    }

    @Override
    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            FTPFile[] files = this.listFilesInDirectory(relPath);
            return files;
        }
        catch (IOException e) {
            this.disconnect();
            FTPFile[] files = this.listFilesInDirectory(relPath);
            return files;
        }
    }

    private FTPFile[] listFilesInDirectory(String relPath) throws IOException {
        FTPFile[] files = this.getFtpClient().listFiles(relPath);
        if (FTPReply.isPositiveCompletion(this.getFtpClient().getReplyCode())) {
            return files;
        }
        String workingDirectory = null;
        if (relPath != null) {
            workingDirectory = this.getFtpClient().printWorkingDirectory();
            if (!this.getFtpClient().changeWorkingDirectory(relPath)) {
                return null;
            }
        }
        files = this.getFtpClient().listFiles();
        if (relPath != null && !this.getFtpClient().changeWorkingDirectory(workingDirectory)) {
            throw new FileSystemException("vfs.provider.ftp.wrapper/change-work-directory-back.error", (Object)workingDirectory);
        }
        return files;
    }

    @Override
    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(relPath);
        }
    }

    @Override
    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().deleteFile(relPath);
        }
    }

    @Override
    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().rename(oldName, newName);
        }
    }

    @Override
    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(relPath);
        }
    }

    @Override
    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    @Override
    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(relPath);
        }
    }

    @Override
    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    @Override
    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(relPath);
        }
    }

    @Override
    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(relPath);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    @Override
    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }
}

