/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.util.Cryptor;
import org.apache.commons.vfs2.util.CryptorFactory;

public class HostFileNameParser
extends AbstractFileNameParser {
    private final int defaultPort;
    private static final HostFileNameParser INSTANCE = new HostFileNameParser(21);

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public HostFileNameParser(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        Authority auth = this.extractToPath(filename, name);
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new GenericFileName(auth.scheme, auth.hostName, auth.port, this.defaultPort, auth.userName, auth.password, path, fileType);
    }

    protected Authority extractToPath(String uri, StringBuilder name) throws FileSystemException {
        String hostName;
        String password;
        String userName;
        Authority auth = new Authority();
        auth.scheme = UriParser.extractScheme(uri, name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)uri);
        }
        name.delete(0, 2);
        String userInfo = this.extractUserInfo(name);
        if (userInfo != null) {
            int idx = userInfo.indexOf(58);
            if (idx == -1) {
                userName = userInfo;
                password = null;
            } else {
                userName = userInfo.substring(0, idx);
                password = userInfo.substring(idx + 1);
            }
        } else {
            userName = null;
            password = null;
        }
        auth.userName = UriParser.decode(userName);
        auth.password = UriParser.decode(password);
        if (auth.password != null && auth.password.startsWith("{") && auth.password.endsWith("}")) {
            try {
                Cryptor cryptor = CryptorFactory.getCryptor();
                auth.password = cryptor.decrypt(auth.password.substring(1, auth.password.length() - 1));
            }
            catch (Exception ex) {
                throw new FileSystemException("Unable to decrypt password", ex);
            }
        }
        if ((hostName = this.extractHostName(name)) == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", (Object)uri);
        }
        auth.hostName = hostName.toLowerCase();
        auth.port = this.extractPort(name, uri);
        if (name.length() > 0 && name.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider/missing-hostname-path-sep.error", (Object)uri);
        }
        return auth;
    }

    protected String extractUserInfo(StringBuilder name) {
        int maxlen = name.length();
        for (int pos = 0; pos < maxlen; ++pos) {
            char ch = name.charAt(pos);
            if (ch == '@') {
                String userInfo = name.substring(0, pos);
                name.delete(0, pos + 1);
                return userInfo;
            }
            if (ch == '/' || ch == '?') break;
        }
        return null;
    }

    protected String extractHostName(StringBuilder name) {
        char ch;
        int pos;
        int maxlen = name.length();
        for (pos = 0; pos < maxlen && (ch = name.charAt(pos)) != '/' && ch != ';' && ch != '?' && ch != ':' && ch != '@' && ch != '&' && ch != '=' && ch != '+' && ch != '$' && ch != ','; ++pos) {
        }
        if (pos == 0) {
            return null;
        }
        String hostname = name.substring(0, pos);
        name.delete(0, pos);
        return hostname;
    }

    protected int extractPort(StringBuilder name, String uri) throws FileSystemException {
        char ch;
        int pos;
        if (name.length() < 1 || name.charAt(0) != ':') {
            return -1;
        }
        int maxlen = name.length();
        for (pos = 1; pos < maxlen && (ch = name.charAt(pos)) >= '0' && ch <= '9'; ++pos) {
        }
        String port = name.substring(1, pos);
        name.delete(0, pos);
        if (port.length() == 0) {
            throw new FileSystemException("vfs.provider/missing-port.error", (Object)uri);
        }
        return Integer.parseInt(port);
    }

    protected static class Authority {
        private String scheme;
        private String hostName;
        private String userName;
        private String password;
        private int port;

        protected Authority() {
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

