/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.remotefilesystem.server.util;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;

public class FileTransportUtils {
    private static final Logger log = LoggerFactory.getLogger(FileTransportUtils.class);
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");

    public static FileSystemOptions attachFileSystemOptions(Map<String, String> options) throws RemoteFileSystemConnectorException {
        if (options == null) {
            return null;
        }
        FileSystemOptions opts = new FileSystemOptions();
        String listeningDirURI = options.get("uri");
        if (listeningDirURI.toLowerCase(Locale.getDefault()).startsWith("ftp")) {
            FileTransportUtils.setFtpOptions(options, opts);
        } else if (listeningDirURI.toLowerCase(Locale.getDefault()).startsWith("sftp")) {
            FileTransportUtils.setSftpOptions(options, opts);
        }
        return opts;
    }

    private static void setFtpOptions(Map<String, String> options, FileSystemOptions opts) {
        FtpFileSystemConfigBuilder configBuilder = FtpFileSystemConfigBuilder.getInstance();
        if (options.get("PASSIVE_MODE") != null) {
            configBuilder.setPassiveMode(opts, Boolean.parseBoolean(options.get("PASSIVE_MODE")));
        }
        if (options.get("USER_DIR_IS_ROOT") != null) {
            configBuilder.setUserDirIsRoot(opts, Boolean.parseBoolean("USER_DIR_IS_ROOT"));
        }
    }

    private static void setSftpOptions(Map<String, String> options, FileSystemOptions opts) throws RemoteFileSystemConnectorException {
        SftpFileSystemConfigBuilder configBuilder = SftpFileSystemConfigBuilder.getInstance();
        if (options.get("USER_DIR_IS_ROOT") != null) {
            configBuilder.setUserDirIsRoot(opts, Boolean.parseBoolean("USER_DIR_IS_ROOT"));
        }
        if (options.get("IDENTITY") != null) {
            try {
                configBuilder.setIdentityInfo(opts, new IdentityInfo(new File(options.get("IDENTITY"))));
            }
            catch (FileSystemException e) {
                throw new RemoteFileSystemConnectorException(e.getMessage(), e);
            }
        }
        if (options.get("IDENTITY_PASS_PHRASE") != null) {
            try {
                configBuilder.setIdentityPassPhrase(opts, options.get("IDENTITY_PASS_PHRASE"));
            }
            catch (FileSystemException e) {
                throw new RemoteFileSystemConnectorException(e.getMessage(), e);
            }
        }
        if (options.get("AVOID_PERMISSION_CHECK") != null) {
            configBuilder.setAvoidPermissionCheck(opts, options.get("AVOID_PERMISSION_CHECK"));
        }
    }

    public static String maskURLPassword(String url) {
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            Matcher pwdMatcher = PASSWORD_PATTERN.matcher(url);
            return pwdMatcher.replaceFirst("\":***@\"");
        }
        return url;
    }
}

