/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.file.processors;

import com.google.common.base.Stopwatch;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.extension.io.file.metrics.SourceMetrics;
import io.siddhi.extension.io.file.metrics.StreamStatus;
import io.siddhi.extension.io.file.util.FileSourceConfiguration;
import io.siddhi.extension.util.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.wso2.carbon.messaging.BinaryCarbonMessage;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.carbon.metrics.core.Gauge;

public class FileProcessor
implements CarbonMessageProcessor {
    private static final Logger log = Logger.getLogger(FileProcessor.class);
    private final SourceEventListener sourceEventListener;
    private final FileSourceConfiguration fileSourceConfiguration;
    private final String mode;
    private final Pattern pattern;
    private int readBytes;
    private final StringBuilder sb;
    private final String[] requiredProperties;
    private Stopwatch stopwatch;
    private long lineCount;
    private long readingLine;
    private long totalReadByteSize;
    private double fileSize;
    private String fileURI;
    private SourceMetrics metrics;
    private long startedTime;
    private long completedTime;
    private boolean send;
    private long previousEventCount;

    public FileProcessor(SourceEventListener sourceEventListener, FileSourceConfiguration fileSourceConfiguration, SourceMetrics sourceMetrics) {
        this.sourceEventListener = sourceEventListener;
        this.fileSourceConfiguration = fileSourceConfiguration;
        this.requiredProperties = fileSourceConfiguration.getRequiredProperties();
        this.mode = fileSourceConfiguration.getMode();
        this.sb = "regex".equalsIgnoreCase(this.mode) && fileSourceConfiguration.isTailingEnabled() ? fileSourceConfiguration.getTailingRegexStringBuilder() : new StringBuilder();
        this.pattern = fileSourceConfiguration.getPattern();
        if (sourceMetrics != null) {
            this.metrics = sourceMetrics;
            this.fileURI = fileSourceConfiguration.getCurrentlyReadingFileURI();
            this.previousEventCount = ((SourceMapper)sourceEventListener).getEventCount();
            this.stopwatch = Stopwatch.createStarted();
            this.startedTime = System.currentTimeMillis();
            this.fileSize = Utils.getFileSize(this.fileURI);
            this.metrics.getStartedTimeMetric(System.currentTimeMillis());
            boolean add = this.metrics.getFilesURI().add(this.fileURI);
            if (add) {
                try {
                    this.lineCount = Utils.getLinesCount(this.fileURI);
                    this.metrics.getFileSizeMetric((Gauge<Double>)((Gauge)() -> this.fileSize));
                    this.metrics.getReadPercentageMetric(this.fileURI);
                    this.metrics.getReadLineCountMetric().inc(this.lineCount);
                    this.metrics.getValidEventCountMetric();
                    this.metrics.getTotalErrorCount();
                    if (fileSourceConfiguration.isTailingEnabled()) {
                        this.metrics.getTailEnabledMetric(1);
                        this.metrics.getElapseTimeMetric((Gauge<Long>)((Gauge)() -> this.stopwatch.elapsed().toMillis()));
                    } else {
                        this.metrics.getTailEnabledMetric(0);
                        this.metrics.getElapseTimeMetric((Gauge<Long>)((Gauge)() -> {
                            if (this.completedTime != 0L) {
                                return this.completedTime - this.startedTime;
                            }
                            return 0L;
                        }));
                    }
                    this.metrics.getFileStatusMetric();
                }
                catch (IOException e) {
                    log.error((Object)("Error occurred while getting the lines count in '" + this.fileURI + "'."), (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean receive(CarbonMessage carbonMessage, CarbonCallback carbonCallback) throws Exception {
        if (carbonMessage instanceof BinaryCarbonMessage) {
            byte[] content = ((BinaryCarbonMessage)carbonMessage).readBytes().array();
            String[] requiredPropertyValues = new String[]{};
            HashMap requiredPropertiesMap = new HashMap();
            if ("regex".equalsIgnoreCase(this.mode) || "text.full".equalsIgnoreCase(this.mode)) {
                this.extractRequiredProperties(carbonMessage, requiredPropertiesMap);
            } else {
                requiredPropertyValues = this.getRequiredPropertyValues(carbonMessage);
            }
            long filePointer = 0L;
            if ("line".equalsIgnoreCase(this.mode) && this.fileSourceConfiguration.isTailingEnabled()) {
                filePointer = (Long)carbonMessage.getProperties().get("currentPosition");
            }
            if (carbonCallback != null) {
                carbonCallback.done(carbonMessage);
            }
            String msg = new String(content, StandardCharsets.UTF_8);
            if ("text.full".equalsIgnoreCase(this.mode)) {
                if (msg.length() > 0) {
                    this.sourceEventListener.onEvent((Object)new String(content, StandardCharsets.UTF_8), this.getRequiredPropertyValuesInRegexMode(true, requiredPropertiesMap));
                    this.send = true;
                }
            } else if ("binary.full".equalsIgnoreCase(this.mode)) {
                if (msg.length() > 0) {
                    this.sourceEventListener.onEvent((Object)content, requiredPropertyValues);
                    this.send = true;
                }
            } else if ("binary.chunked".equalsIgnoreCase(this.mode)) {
                if (msg.length() > 0) {
                    this.sourceEventListener.onEvent((Object)content, requiredPropertyValues);
                }
            } else if ("line".equalsIgnoreCase(this.mode)) {
                if (!this.fileSourceConfiguration.isTailingEnabled()) {
                    String line;
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        this.readBytes = line.length();
                        this.sourceEventListener.onEvent((Object)line.trim(), requiredPropertyValues);
                        this.send = true;
                    }
                } else if (msg.length() > 0) {
                    this.readBytes = msg.getBytes(StandardCharsets.UTF_8).length;
                    this.fileSourceConfiguration.updateFilePointer(filePointer);
                    this.sourceEventListener.onEvent((Object)msg, requiredPropertyValues);
                    this.send = true;
                    if (this.metrics != null) {
                        this.increaseTailingMetrics();
                    }
                }
            } else if ("regex".equalsIgnoreCase(this.mode)) {
                int lastMatchedIndex = 0;
                int remainedLength = 0;
                if (!this.fileSourceConfiguration.isTailingEnabled()) {
                    char[] buf = new char[10];
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    int endOfStream = bufferedReader.read(buf);
                    String event = null;
                    String prevEvent = null;
                    while (endOfStream != -1) {
                        lastMatchedIndex = 0;
                        this.sb.append(new String(buf));
                        Matcher matcher = this.pattern.matcher(this.sb.toString().trim());
                        boolean matchFound = false;
                        while (matcher.find()) {
                            matchFound = true;
                            prevEvent = event;
                            event = matcher.group(0);
                            lastMatchedIndex = matcher.end();
                            if (this.fileSourceConfiguration.getEndRegex() == null) {
                                try {
                                    event = event.substring(0, lastMatchedIndex -= this.fileSourceConfiguration.getBeginRegex().length() - 2);
                                }
                                catch (StringIndexOutOfBoundsException e) {
                                    log.error((Object)e.getMessage());
                                }
                            } else if (this.fileSourceConfiguration.getBeginRegex() == null) {
                                if (remainedLength < lastMatchedIndex) {
                                    lastMatchedIndex += remainedLength;
                                }
                                remainedLength = this.sb.length() - event.length() - remainedLength - 1;
                            }
                            buf = new char[10];
                            endOfStream = bufferedReader.read(buf);
                        }
                        if (matchFound && endOfStream == -1) {
                            if (prevEvent != null) {
                                this.sourceEventListener.onEvent((Object)prevEvent, this.getRequiredPropertyValuesInRegexMode(false, requiredPropertiesMap));
                                this.send = true;
                            }
                            this.sourceEventListener.onEvent((Object)event, this.getRequiredPropertyValuesInRegexMode(true, requiredPropertiesMap));
                            this.send = true;
                        } else if (matchFound) {
                            if (prevEvent != null) {
                                this.sourceEventListener.onEvent((Object)prevEvent, this.getRequiredPropertyValuesInRegexMode(false, requiredPropertiesMap));
                                this.send = true;
                            }
                            prevEvent = event;
                        } else {
                            buf = new char[10];
                            endOfStream = bufferedReader.read(buf);
                            if (endOfStream == -1 && prevEvent != null) {
                                this.sourceEventListener.onEvent((Object)prevEvent, this.getRequiredPropertyValuesInRegexMode(true, requiredPropertiesMap));
                                this.send = true;
                            }
                        }
                        String tmp = this.sb.substring(lastMatchedIndex);
                        this.sb.setLength(0);
                        this.sb.append(tmp);
                    }
                    if (this.fileSourceConfiguration.getBeginRegex() != null && this.fileSourceConfiguration.getEndRegex() == null) {
                        Pattern p = Pattern.compile(this.fileSourceConfiguration.getBeginRegex() + "((.|\n)*?)");
                        Matcher m = p.matcher(this.sb.toString());
                        while (m.find()) {
                            event = m.group(0);
                            this.sourceEventListener.onEvent((Object)this.sb.substring(this.sb.indexOf(event)), requiredPropertyValues);
                            this.send = true;
                        }
                    }
                } else {
                    this.fileSourceConfiguration.updateFilePointer(this.readBytes);
                    this.sb.append(new String(content, StandardCharsets.UTF_8));
                    Matcher matcher = this.pattern.matcher(this.sb.toString().trim());
                    while (matcher.find()) {
                        String event = matcher.group(0);
                        lastMatchedIndex = matcher.end();
                        if (this.fileSourceConfiguration.getEndRegex() == null) {
                            event = event.substring(0, lastMatchedIndex -= this.fileSourceConfiguration.getBeginRegex().length() - 2);
                        } else if (this.fileSourceConfiguration.getBeginRegex() == null) {
                            if (remainedLength < lastMatchedIndex) {
                                lastMatchedIndex += remainedLength;
                            }
                            remainedLength = this.sb.length() - event.length() - remainedLength - 1;
                        }
                        this.sourceEventListener.onEvent((Object)event, requiredPropertyValues);
                        this.send = true;
                        this.readBytes += content.length;
                        if (this.metrics == null) continue;
                        this.increaseTailingMetrics();
                    }
                    String tmp = this.sb.substring(lastMatchedIndex);
                    this.sb.setLength(0);
                    this.sb.append(tmp);
                }
            }
            if (this.metrics != null && this.send) {
                this.increaseMetrics(content.length);
                this.totalReadByteSize += (long)content.length;
                ++this.readingLine;
                this.completedTime = System.currentTimeMillis();
                this.send = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setTransportSender(TransportSender transportSender) {
    }

    @Override
    public void setClientConnector(ClientConnector clientConnector) {
    }

    @Override
    public String getId() {
        return "file-message-processor";
    }

    private void increaseMetrics(int byteLength) {
        this.metrics.getTotalFileReadCount().inc();
        this.metrics.getTotalReadsMetrics().inc();
        this.metrics.getReadByteMetric().inc((long)byteLength);
        this.metrics.getElapseTimeMetric((Gauge<Long>)((Gauge)() -> this.stopwatch.elapsed().toMillis()));
        this.metrics.setReadPercentage((double)this.totalReadByteSize / this.fileSize * 100.0, this.fileURI);
        long eventCount = ((SourceMapper)this.sourceEventListener).getEventCount() - this.previousEventCount;
        this.metrics.getValidEventCountMetric().inc(eventCount);
        this.previousEventCount = ((SourceMapper)this.sourceEventListener).getEventCount();
    }

    private void increaseTailingMetrics() {
        if (this.readingLine >= this.lineCount) {
            this.metrics.getReadLineCountMetric().inc();
        }
        this.fileSize = Utils.getFileSize(this.fileSourceConfiguration.getCurrentlyReadingFileURI());
        this.metrics.getSourceFileStatusMap().replace(Utils.getShortFilePath(this.fileURI), StreamStatus.PROCESSING);
        this.metrics.getTailEnabledFilesMap().replace(Utils.getShortFilePath(this.fileURI), System.currentTimeMillis());
    }

    private String[] getRequiredPropertyValues(CarbonMessage carbonMessage) {
        String[] values = new String[this.requiredProperties.length];
        int i = 0;
        for (String propertyKey : this.requiredProperties) {
            Object value = carbonMessage.getProperty(propertyKey);
            if (value != null) {
                values[i++] = value.toString();
                continue;
            }
            log.error((Object)("Failed to find required transport property '" + propertyKey + "'. Assigning null value"));
            values[i++] = null;
        }
        return values;
    }

    private String[] getRequiredPropertyValuesInRegexMode(boolean eof, Map requiredPropertyValues) {
        String[] values = new String[this.requiredProperties.length];
        int i = 0;
        for (String propertyName : this.requiredProperties) {
            if (propertyName.equalsIgnoreCase("eof")) {
                values[i++] = String.valueOf(eof);
                continue;
            }
            Object value = requiredPropertyValues.get(propertyName);
            if (value == null) {
                log.error((Object)("Failed to find required transport property '" + propertyName + "'. Assigning null value"));
                values[i++] = null;
                continue;
            }
            values[i++] = value.toString();
        }
        return values;
    }

    private void extractRequiredProperties(CarbonMessage carbonMessage, Map requiredPropertyValues) {
        for (String property : this.requiredProperties) {
            Object value = carbonMessage.getProperty(property);
            if (value != null) {
                requiredPropertyValues.put(property, value);
                continue;
            }
            log.error((Object)("Failed to find required transport property '" + property + "'"));
        }
    }
}

