/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.file.connector.sender;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BinaryCarbonMessage;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.messaging.exceptions.ClientConnectorException;

public class VFSClientConnector
implements ClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(VFSClientConnector.class);
    private FileSystemOptions opts = new FileSystemOptions();
    private CarbonMessageProcessor carbonMessageProcessor;
    private String scheme;
    private Map<String, Object> properties;

    @Override
    public Object init(CarbonMessage cMsg, CarbonCallback callback, Map<String, Object> properties) throws ClientConnectorException {
        this.properties = properties;
        this.setOptions(properties);
        return Boolean.TRUE;
    }

    private void setOptions(Map<String, Object> properties) throws ClientConnectorException {
        this.scheme = null;
        if (properties.get("PROTOCOL") != null) {
            this.scheme = properties.get("PROTOCOL").toString();
        } else if (properties.get("PROTOCOL") == null && properties.get("uri") != null) {
            this.scheme = UriParser.extractScheme(properties.get("uri").toString());
        }
        if ("ftp".equals(this.scheme)) {
            if (properties.get("FTP_PASSIVE_MODE") != null) {
                FtpFileSystemConfigBuilder.getInstance().setPassiveMode(this.opts, Boolean.parseBoolean(properties.get("FTP_PASSIVE_MODE").toString()));
            } else {
                FtpFileSystemConfigBuilder.getInstance().setPassiveMode(this.opts, true);
            }
            if (properties.get("USER_DIR_IS_ROOT") != null) {
                FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(this.opts, Boolean.parseBoolean(properties.get("USER_DIR_IS_ROOT").toString()));
            } else {
                FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(this.opts, true);
            }
        } else if ("sftp".equals(this.scheme)) {
            if (properties.get("USER_DIR_IS_ROOT") != null) {
                SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(this.opts, Boolean.parseBoolean(properties.get("USER_DIR_IS_ROOT").toString()));
            } else {
                FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(this.opts, true);
            }
            if (properties.get("IDENTITY") != null) {
                try {
                    SftpFileSystemConfigBuilder.getInstance().setIdentityInfo(this.opts, new IdentityInfo(new File(properties.get("IDENTITY").toString())));
                }
                catch (FileSystemException e) {
                    throw new ClientConnectorException(e.getMessage(), e);
                }
            }
            if (properties.get("IDENTITY_PASS_PHRASE") != null) {
                try {
                    SftpFileSystemConfigBuilder.getInstance().setIdentityPassPhrase(this.opts, properties.get("IDENTITY_PASS_PHRASE").toString());
                }
                catch (FileSystemException e) {
                    throw new ClientConnectorException(e.getMessage(), e);
                }
            }
            if (properties.get("AVOID_PERMISSION_CHECK") != null) {
                SftpFileSystemConfigBuilder.getInstance().setAvoidPermissionCheck(this.opts, properties.get("AVOID_PERMISSION_CHECK").toString());
            } else {
                SftpFileSystemConfigBuilder.getInstance().setAvoidPermissionCheck(this.opts, "true");
            }
        }
    }

    @Override
    public boolean send(CarbonMessage carbonMessage, CarbonCallback carbonCallback) throws ClientConnectorException {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean send(CarbonMessage carbonMessage, CarbonCallback carbonCallback, Map<String, String> map) throws ClientConnectorException {
        String fileURI = map.get("uri");
        String action = map.get("action");
        long readWaitTimeout = 1000L;
        if (null != map.get("fileReadWaitTimeout")) {
            readWaitTimeout = Long.parseLong(map.get("fileReadWaitTimeout"));
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        BufferedReader bufferedReader = null;
        try {
            FileSystemManager fsManager = VFS.getManager();
            if (this.scheme == null && this.properties != null) {
                this.properties.put("uri", fileURI);
                this.setOptions(this.properties);
            }
            FileObject path = fsManager.resolveFile(fileURI, this.opts);
            FileType fileType = path.getType();
            switch (action.toLowerCase(Locale.ENGLISH)) {
                case "create": {
                    boolean isFolder = Boolean.parseBoolean(map.getOrDefault("create-folder", "false"));
                    if (path.exists()) {
                        throw new ClientConnectorException("File already exists: " + path.getName().getURI());
                    }
                    if (isFolder) {
                        path.createFolder();
                        return true;
                    } else {
                        path.createFile();
                        return true;
                    }
                }
                case "write": {
                    if (!path.exists()) {
                        path.createFile();
                        path.refresh();
                        fileType = path.getType();
                    }
                    if (fileType != FileType.FILE) return true;
                    if (!(carbonMessage instanceof BinaryCarbonMessage)) {
                        throw new ClientConnectorException("Carbon message received is not a BinaryCarbonMessage");
                    }
                    BinaryCarbonMessage binaryCarbonMessage = (BinaryCarbonMessage)carbonMessage;
                    ByteBuffer byteBuffer = binaryCarbonMessage.readBytes();
                    byte[] bytes = byteBuffer.array();
                    outputStream = map.get("append") != null ? path.getContent().getOutputStream(Boolean.parseBoolean(map.get("append"))) : path.getContent().getOutputStream();
                    outputStream.write(bytes);
                    outputStream.flush();
                    return true;
                }
                case "delete": {
                    if (!path.exists()) throw new ClientConnectorException("Failed to delete file: " + path.getName().getURI() + " not found");
                    int filesDeleted = path.delete(Selectors.SELECT_ALL);
                    if (!logger.isDebugEnabled()) return true;
                    logger.debug(filesDeleted + " files successfully deleted");
                    return true;
                }
                case "copy": {
                    if (!path.exists()) throw new ClientConnectorException("Failed to copy file: " + path.getName().getURI() + " not found");
                    String destination = map.get("destination");
                    FileObject dest = fsManager.resolveFile(destination, this.opts);
                    dest.copyFrom(path, Selectors.SELECT_ALL);
                    return true;
                }
                case "move": {
                    if (!path.exists()) throw new ClientConnectorException("Failed to move file: " + path.getName().getURI() + " not found");
                    String moveIfExistMode = map.get("move.if.exist.mode");
                    String destination = map.get("destination");
                    FileObject newPath = fsManager.resolveFile(destination, this.opts);
                    FileObject parent = newPath.getParent();
                    if (parent != null && !parent.exists()) {
                        parent.createFolder();
                    }
                    if (!newPath.exists()) {
                        path.moveTo(newPath);
                        return true;
                    } else {
                        if (moveIfExistMode == null) throw new ClientConnectorException("The file at " + newPath.getURL().toString() + " already exists or it is a directory");
                        if (moveIfExistMode.equalsIgnoreCase("keep")) {
                            destination = destination + "_" + UUID.randomUUID().toString();
                            path.moveTo(fsManager.resolveFile(destination, this.opts));
                            return true;
                        } else {
                            if (!moveIfExistMode.equalsIgnoreCase("overwrite")) throw new ClientConnectorException("The file at " + newPath.getURL().toString() + " already exists or it is a directory and the mode used for if file exist " + moveIfExistMode + " is not supported. ");
                            int fileDeleted = newPath.delete(Selectors.SELECT_SELF);
                            if (logger.isDebugEnabled()) {
                                logger.debug(fileDeleted + " file successfully deleted in " + destination);
                            }
                            path.moveTo(newPath);
                            return true;
                        }
                    }
                }
                case "read": {
                    String fileExtension;
                    String filePath;
                    long fileContentLastModifiedTime;
                    if (!path.exists()) throw new ClientConnectorException("Failed to read file: " + path.getName().getURI() + " not found");
                    do {
                        fileContentLastModifiedTime = path.getContent().getLastModifiedTime();
                        Thread.sleep(readWaitTimeout);
                    } while (fileContentLastModifiedTime < path.getContent().getLastModifiedTime());
                    String scheme = UriParser.extractScheme(fileURI);
                    if (scheme == null || scheme.equals("file")) {
                        filePath = path.getName().getPath();
                        fileExtension = filePath.substring(filePath.lastIndexOf(".") + 1);
                        bufferedReader = Files.newBufferedReader(Paths.get(filePath, new String[0]));
                    } else {
                        String fileName = path.getName().getBaseName();
                        filePath = path.getName().getPath();
                        fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
                        bufferedReader = new BufferedReader(new InputStreamReader(path.getContent().getInputStream(), StandardCharsets.UTF_8));
                    }
                    String mode = map.get("mode");
                    if ("line".equalsIgnoreCase(mode) && !fileExtension.equalsIgnoreCase("bin")) {
                        boolean readOnlyHeader = Boolean.parseBoolean(map.get("read.only.header"));
                        boolean readOnlyTrailer = Boolean.parseBoolean(map.get("read.only.trailer"));
                        boolean trailerSkipped = Boolean.parseBoolean(map.get("skip.trailer"));
                        boolean headerSkipped = !Boolean.parseBoolean(map.get("header.present"));
                        String line = bufferedReader.readLine();
                        if (readOnlyHeader && line != null) {
                            BinaryCarbonMessage message = new BinaryCarbonMessage(ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8)), true);
                            message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                            message.setProperty("file.path", filePath);
                            message.setProperty("eof", true);
                            this.carbonMessageProcessor.receive(message, carbonCallback);
                            return true;
                        }
                        if (readOnlyTrailer && line != null) {
                            BinaryCarbonMessage message;
                            if (!Boolean.parseBoolean(map.get("header.present"))) {
                                message = new BinaryCarbonMessage(ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8)), true);
                                message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                                message.setProperty("file.path", filePath);
                                message.setProperty("eof", true);
                            } else {
                                message = null;
                            }
                            while ((line = bufferedReader.readLine()) != null) {
                                String lastLine = line;
                                message = new BinaryCarbonMessage(ByteBuffer.wrap(lastLine.getBytes(StandardCharsets.UTF_8)), true);
                                message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                                message.setProperty("file.path", filePath);
                                message.setProperty("eof", true);
                            }
                            if (null == message) return true;
                            this.carbonMessageProcessor.receive(message, carbonCallback);
                            return true;
                        }
                        if (trailerSkipped && line != null) {
                            boolean skipSendingLine = Boolean.parseBoolean(map.get("header.present"));
                            while (line != null) {
                                BinaryCarbonMessage message = new BinaryCarbonMessage(ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8)), true);
                                message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                                message.setProperty("file.path", filePath);
                                message.setProperty("eof", false);
                                line = bufferedReader.readLine();
                                while (line != null && line.isEmpty()) {
                                    line = bufferedReader.readLine();
                                }
                                if (!skipSendingLine) {
                                    boolean isEOFAfterNextLine;
                                    if (line == null) continue;
                                    bufferedReader.mark(0);
                                    String nextLine = bufferedReader.readLine();
                                    boolean bl = isEOFAfterNextLine = nextLine == null;
                                    if (isEOFAfterNextLine) {
                                        message.setProperty("eof", true);
                                    }
                                    this.carbonMessageProcessor.receive(message, carbonCallback);
                                    if (isEOFAfterNextLine) {
                                        return true;
                                    }
                                    bufferedReader.reset();
                                    continue;
                                }
                                skipSendingLine = false;
                            }
                            return true;
                        }
                        while (line != null) {
                            BinaryCarbonMessage message = new BinaryCarbonMessage(ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8)), true);
                            message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                            message.setProperty("file.path", filePath);
                            line = bufferedReader.readLine();
                            while (line != null && line.isEmpty()) {
                                line = bufferedReader.readLine();
                            }
                            if (line == null) {
                                message.setProperty("eof", true);
                            } else {
                                message.setProperty("eof", false);
                            }
                            if (headerSkipped) {
                                this.carbonMessageProcessor.receive(message, carbonCallback);
                                continue;
                            }
                            headerSkipped = true;
                        }
                        return true;
                    }
                    if ("binary.chunked".equalsIgnoreCase(mode)) {
                        int readLength;
                        inputStream = path.getContent().getInputStream();
                        long size = path.getContent().getSize();
                        int bufferSize = Integer.parseInt(map.get("buffer.size"));
                        logger.debug("Reading " + path.getName() + " on " + mode + ". Chunk size: " + bufferSize + " bytes, File size: " + size + " bytes.");
                        byte[] buffer = new byte[bufferSize];
                        int sequenceNumber = 1;
                        bufferedReader = Files.newBufferedReader(Paths.get(filePath, new String[0]));
                        while ((readLength = inputStream.read(buffer)) != -1) {
                            if (readLength != buffer.length) {
                                buffer = Arrays.copyOfRange(buffer, 0, readLength);
                            }
                            BinaryCarbonMessage message = new BinaryCarbonMessage(ByteBuffer.wrap(buffer), true);
                            message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                            message.setProperty("file.name", path.getName().getBaseName());
                            message.setProperty("content.length", size);
                            message.setProperty("sequence.number", sequenceNumber++);
                            message.setProperty("eof", inputStream.available() <= 0);
                            this.carbonMessageProcessor.receive(message, carbonCallback);
                            buffer = new byte[bufferSize];
                        }
                        logger.debug("Reading " + path.getPublicURIString() + " is completed.");
                        return true;
                    } else {
                        inputStream = path.getContent().getInputStream();
                        BinaryCarbonMessage message = new BinaryCarbonMessage(ByteBuffer.wrap(VFSClientConnector.toByteArray(inputStream)), true);
                        message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                        message.setProperty("file.path", filePath);
                        this.carbonMessageProcessor.receive(message, carbonCallback);
                        return true;
                    }
                }
                case "exists": {
                    TextCarbonMessage message = new TextCarbonMessage(Boolean.toString(path.exists()));
                    message.setProperty("DIRECTION", "DIRECTION_RESPONSE");
                    this.carbonMessageProcessor.receive(message, carbonCallback);
                    return true;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (RuntimeException e) {
            throw new ClientConnectorException("Runtime Exception occurred : " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ClientConnectorException("Exception occurred while processing file: " + e.getMessage(), e);
        }
        finally {
            VFSClientConnector.closeQuietly(bufferedReader);
            VFSClientConnector.closeQuietly(inputStream);
            VFSClientConnector.closeQuietly(outputStream);
        }
    }

    @Override
    public String getProtocol() {
        return "file";
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        int n1;
        long count = 0L;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while (-1 != (n1 = input.read(buffer))) {
            output.write(buffer, 0, n1);
            count += (long)n1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(count + " bytes read");
        }
        byte[] bytes = output.toByteArray();
        VFSClientConnector.closeQuietly(output);
        return bytes;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.error("Error occurred when closing stream", (Throwable)e);
        }
    }

    @Override
    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        this.carbonMessageProcessor = carbonMessageProcessor;
    }
}

