/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.file.connector.server;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.connector.framework.server.polling.PollingServerConnector;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;
import org.wso2.transport.file.connector.server.FileConsumer;
import org.wso2.transport.file.connector.server.exception.FileServerConnectorException;

public class FileServerConnector
extends PollingServerConnector {
    private static final Logger log = LoggerFactory.getLogger(FileServerConnector.class);
    private static final long FILE_CONNECTOR_DEFAULT_INTERVAL = 10000L;
    private CarbonMessageProcessor messageProcessor;
    private FileConsumer consumer;

    public FileServerConnector(String id, Map<String, String> properties) {
        super(id, properties);
        this.interval = 10000L;
    }

    @Override
    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        this.messageProcessor = carbonMessageProcessor;
    }

    @Override
    protected void init() throws ServerConnectorException {
    }

    @Override
    public void destroy() throws ServerConnectorException {
        this.stop();
    }

    @Override
    public void start() throws ServerConnectorException {
        try {
            this.consumer = new FileConsumer(this.id, this.getProperties(), this.messageProcessor);
            super.start();
        }
        catch (RuntimeException e) {
            throw new ServerConnectorException("Failed to start File Server Connector for service: " + this.id, e);
        }
    }

    @Override
    public void poll() {
        try {
            this.consumer.consume();
        }
        catch (FileServerConnectorException e) {
            log.error("Error in executing the polling cycle of File Server Connector for service: " + this.id, (Throwable)e);
        }
    }
}

