/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Logger;

@Extension(name="size", namespace="file", description="This function checks for a given file's size", parameters={@Parameter(name="uri", description="Absolute path to the file or directory to be checked for the size.", type={DataType.STRING}, dynamic=true), @Parameter(name="file.system.options", description="The file options in key:value pairs separated by commas. \neg:'USER_DIR_IS_ROOT:false,PASSIVE_MODE:true,AVOID_PERMISSION_CHECK:true,IDENTITY:file://demo/.ssh/id_rsa,IDENTITY_PASS_PHRASE:wso2carbon'\nNote: when IDENTITY is used, use a RSA PRIVATE KEY", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>")}, parameterOverloads={@ParameterOverload(parameterNames={"uri"}), @ParameterOverload(parameterNames={"uri", "file.system.options"})}, returnAttributes={@ReturnAttribute(description="Size of the given file or the directory.", type={DataType.LONG})}, examples={@Example(syntax="file:size('/User/wso2/source/test.txt') as fileSize", description="Size of a file in a given path will be returned.")})
public class FileSizeExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(FileSizeExtension.class);
    private Attribute.Type returnType = Attribute.Type.LONG;
    private String fileSystemOptions = null;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor executor1;
        int inputExecutorLength = attributeExpressionExecutors.length;
        if (inputExecutorLength > 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to file:size() function, required 2, but found " + inputExecutorLength);
        }
        if (inputExecutorLength == 2 && attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor) {
            this.fileSystemOptions = ((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue().toString();
        }
        if ((executor1 = attributeExpressionExecutors[0]).getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the filePath (first argument) of file:size() function, required " + Attribute.Type.STRING.toString() + ", but found " + executor1.getReturnType().toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return FileSizeExtension.calculateFileSizeRecusrively(Utils.getFileObject((String)data[0], this.fileSystemOptions));
    }

    protected Object execute(Object data, State state) {
        return FileSizeExtension.calculateFileSizeRecusrively(Utils.getFileObject((String)data, this.fileSystemOptions));
    }

    public static long calculateFileSizeRecusrively(FileObject fileObj) {
        long size = 0L;
        try {
            if (fileObj.isFolder()) {
                FileObject[] files;
                for (FileObject file : files = fileObj.getChildren()) {
                    size += FileSizeExtension.calculateFileSizeRecusrively(file);
                }
            } else {
                size += fileObj.getContent().getSize();
            }
            return size;
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when getting the children of  " + fileObj.getName().getURI(), (Throwable)e);
        }
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

