/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.file.metrics;

import com.google.common.base.Stopwatch;
import io.siddhi.extension.io.file.metrics.Metrics;
import io.siddhi.extension.io.file.metrics.StreamStatus;
import io.siddhi.extension.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Gauge;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

public class SinkMetrics
extends Metrics {
    private static final Logger log = Logger.getLogger(SinkMetrics.class);
    private final Map<String, StreamStatus> sinkFileStatusMap = new HashMap<String, StreamStatus>();
    private final Map<String, Long> sinkFileLastPublishedTimeMap = new HashMap<String, Long>();
    private final Map<String, Stopwatch> sinkElapsedTimeMap = new HashMap<String, Stopwatch>();
    private boolean isStarted;
    private String filePath;
    private final String mapType;
    private final String streamName;
    private String fileName;

    public SinkMetrics(String siddhiAppName, String mapType, String streamName) {
        super(siddhiAppName);
        this.mapType = mapType;
        this.streamName = streamName;
    }

    public Counter getTotalWriteMetrics() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Total.Writes.%s", this.siddhiAppName, "file"), Level.INFO, new Level[0]);
    }

    public Counter getSinkFilesEventCount() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.event.count.%s.%s.%s.%s", this.siddhiAppName, this.fileName + ".filename", this.mapType, this.streamName, this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getSinkLinesCount() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "lines_count", this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getWriteBytes() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "total_written_byte", this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getErrorCount() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "total_error_count", this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getSinkDroppedEvents() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "dropped_events", this.filePath), Level.INFO, new Level[0]);
    }

    public Counter getSinkFileSize() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "file_size", this.filePath), Level.INFO, new Level[0]);
    }

    public void setSinkLastPublishedTime() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "last_published_time", this.filePath), Level.INFO, () -> this.sinkFileLastPublishedTimeMap.getOrDefault(this.filePath, 0L));
    }

    public void setSinkElapsedTime(String fileURI) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "elapsed_time", this.filePath), Level.INFO, () -> {
            if (this.sinkElapsedTimeMap.containsKey(fileURI)) {
                return this.sinkElapsedTimeMap.get(fileURI).elapsed().toMillis();
            }
            return 0;
        });
    }

    public void setSinkFileStatusMetrics() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.File.Sinks.%s.%s", this.siddhiAppName, "file_status", this.filePath), Level.INFO, (Gauge)new FileStatusGauge(this.filePath));
    }

    public void updateMetrics(ExecutorService executorService) {
        if (!this.isStarted) {
            executorService.execute(() -> {
                this.isStarted = true;
                while (this.isStarted) {
                    try {
                        if (!this.sinkFileStatusMap.isEmpty()) {
                            this.sinkFileLastPublishedTimeMap.forEach((filePath, lastPublishedTime) -> {
                                long idleTime = System.currentTimeMillis() - lastPublishedTime;
                                if (idleTime / 1000L >= 8L) {
                                    this.sinkFileStatusMap.replace((String)filePath, StreamStatus.IDLE);
                                }
                            });
                        }
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Error while updating the status of files.", (Throwable)e);
                    }
                }
            });
        }
    }

    public void setFilePath(String fileURI) {
        this.filePath = Utils.getShortFilePath(fileURI);
        this.fileName = Utils.getFileName(fileURI, this);
    }

    public Map<String, StreamStatus> getSinkFileStatusMap() {
        return this.sinkFileStatusMap;
    }

    public Map<String, Long> getSinkFileLastPublishedTimeMap() {
        return this.sinkFileLastPublishedTimeMap;
    }

    public Map<String, Stopwatch> getSinkElapsedTimeMap() {
        return this.sinkElapsedTimeMap;
    }

    public class FileStatusGauge
    implements Gauge<Integer> {
        private final String filePath;

        public FileStatusGauge(String filePath) {
            this.filePath = Utils.getShortFilePath(filePath);
        }

        public Integer getValue() {
            if (SinkMetrics.this.sinkFileStatusMap.containsKey(this.filePath)) {
                return ((StreamStatus)((Object)SinkMetrics.this.sinkFileStatusMap.get(this.filePath))).ordinal();
            }
            return 0;
        }
    }
}

