/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.framework.server.polling;

import java.util.Map;
import org.wso2.carbon.connector.framework.server.polling.PollingTaskRunner;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;

public abstract class PollingServerConnector
extends ServerConnector {
    protected long interval = 1000L;
    protected String cronExpression = null;
    private PollingTaskRunner pollingTaskRunner;

    public PollingServerConnector(String id, Map<String, String> properties) {
        super(id, properties);
    }

    @Override
    public void start() throws ServerConnectorException {
        String pollingInterval;
        String strCronExpression = this.getProperties().get("cronExpression");
        if (strCronExpression != null) {
            this.cronExpression = strCronExpression;
        }
        if ((pollingInterval = this.getProperties().get("pollingInterval")) != null) {
            try {
                this.interval = Long.parseLong(pollingInterval);
            }
            catch (NumberFormatException e) {
                throw new ServerConnectorException("Could not parse parameter: pollingInterval to numeric type: Long", e);
            }
        }
        this.pollingTaskRunner = new PollingTaskRunner(this);
        this.pollingTaskRunner.start();
    }

    @Override
    public void stop() throws ServerConnectorException {
        if (this.pollingTaskRunner != null) {
            this.pollingTaskRunner.terminate();
        }
    }

    @Override
    protected void beginMaintenance() {
        if (this.pollingTaskRunner != null) {
            this.pollingTaskRunner.terminate();
        }
    }

    @Override
    protected void endMaintenance() {
        if (this.pollingTaskRunner != null) {
            this.pollingTaskRunner.start();
        }
    }

    protected abstract void poll();
}

