/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.AbstractFtpClientWrapper;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsClientFactory;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

class FtpsClientWrapper
extends AbstractFtpClientWrapper {
    private static final Log log = LogFactory.getLog(FtpsClientWrapper.class);

    FtpsClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions, Integer connectionTimeout) throws FileSystemException {
        super(root, fileSystemOptions, connectionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FTPSClient createClient() throws FileSystemException {
        FTPSClient fTPSClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.getFileSystemOptions(), FtpFileProvider.AUTHENTICATOR_TYPES);
            char[] userName = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName()));
            char[] password = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()));
            FTPSClient ftpsClient = FtpsClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), userName, password, rootName.getPath(), this.getFileSystemOptions());
            FtpsDataChannelProtectionLevel level = FtpsFileSystemConfigBuilder.getInstance().getDataChannelProtectionLevel(this.getFileSystemOptions());
            if (level != null) {
                try {
                    ftpsClient.execPBSZ(0L);
                    ftpsClient.execPROT(level.name());
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            fTPSClient = ftpsClient;
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return fTPSClient;
    }
}

