/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.mime;

import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import org.apache.commons.vfs2.provider.mime.MimeFileObject;

public class MimeFileContentInfoFactory
implements FileContentInfoFactory {
    @Override
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        ContentType contentType;
        MimeFileObject mimeFile = (MimeFileObject)fileContent.getFile();
        Part part = mimeFile.getPart();
        String contentTypeString = null;
        String charset = null;
        try {
            if (mimeFile.isMultipart()) {
                contentTypeString = part.getContentType();
                charset = "UTF-8";
            }
        }
        catch (MessagingException e) {
            throw new FileSystemException(e);
        }
        if (contentTypeString == null) {
            try {
                contentTypeString = part.getContentType();
            }
            catch (MessagingException e) {
                throw new FileSystemException(e);
            }
        }
        try {
            contentType = new ContentType(contentTypeString);
        }
        catch (MessagingException e) {
            throw new FileSystemException(e);
        }
        if (charset == null) {
            charset = contentType.getParameter("charset");
        }
        return new DefaultFileContentInfo(contentType.getBaseType(), charset);
    }
}

