/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb2;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.DiskShare;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.smb2.Smb2FileName;

public class Smb2ClientWrapper
extends SMBClient {
    private static final Log LOG = LogFactory.getLog(Smb2ClientWrapper.class);
    private static final SmbConfig CONFIG = SmbConfig.builder().withDfsEnabled(true).withMultiProtocolNegotiate(true).build();
    protected final FileSystemOptions fileSystemOptions;
    private final GenericFileName root;
    private SMBClient smbClient;
    private Connection connection;
    private Session session;
    private DiskShare diskShare;

    protected Smb2ClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.smbClient = new SMBClient(CONFIG);
        this.setupClient();
    }

    private void setupClient() throws FileSystemException {
        GenericFileName rootName = this.getRoot();
        String userString = rootName.getUserName();
        String userName = "";
        if (userString != null && !userString.isEmpty()) {
            userName = userString.contains(";") ? userString.substring(userString.indexOf(";") + 1, userString.length()) : userString;
        }
        String password = rootName.getPassword();
        String authDomain = userString.contains(";") ? userString.substring(0, userString.indexOf(";")) : null;
        AuthenticationContext authContext = new AuthenticationContext(userName, password.toCharArray(), authDomain);
        try {
            this.connection = this.smbClient.connect(rootName.getHostName());
            this.session = this.connection.authenticate(authContext);
            String share = ((Smb2FileName)rootName).getShareName();
            this.diskShare = (DiskShare)this.session.connectShare(share);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error while creating connection to " + rootName.getHostName()));
            }
            throw new FileSystemException("vfs.provider.smb2/connect.error", (Object)rootName.getHostName(), (Throwable)e);
        }
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileAllInformation getFileInfo(String relativePath) {
        try {
            return this.diskShare.getFileInformation(relativePath);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Could not get information for file: " + relativePath));
            }
            return null;
        }
    }

    public DiskEntry getDiskEntryWrite(String path, boolean append) {
        return this.diskShare.open(path, EnumSet.of(AccessMask.MAXIMUM_ALLOWED), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.of(SMB2ShareAccess.FILE_SHARE_WRITE), append ? SMB2CreateDisposition.FILE_OPEN_IF : SMB2CreateDisposition.FILE_OVERWRITE_IF, EnumSet.of(SMB2CreateOptions.FILE_NO_COMPRESSION));
    }

    public void createFolder(String path) {
        DiskEntry de = this.getDiskEntryFolderWrite(path);
        de.close();
    }

    public DiskEntry getDiskEntryFolderWrite(String path) {
        return this.diskShare.openDirectory(path, EnumSet.of(AccessMask.GENERIC_ALL), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN_IF, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
    }

    public DiskEntry getDiskEntryRead(String path) {
        return this.diskShare.open(path, EnumSet.of(AccessMask.GENERIC_READ), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_NO_COMPRESSION));
    }

    public String[] getChildren(String path) {
        ArrayList<String> children = new ArrayList<String>();
        for (FileIdBothDirectoryInformation file : this.diskShare.list(path)) {
            String name = file.getFileName();
            if (name.equals(".") || name.equals("..") || name.equals("./") || name.equals("../")) continue;
            children.add(file.getFileName());
        }
        return children.toArray(new String[children.size()]);
    }

    public void delete(String path) throws FileSystemException {
        FileAllInformation info;
        try {
            info = this.diskShare.getFileInformation(path);
        }
        catch (SMBApiException e) {
            throw new FileSystemException("Could not delete file " + path);
        }
        if (info.getStandardInformation().isDirectory()) {
            this.diskShare.rmdir(path, true);
        } else {
            this.diskShare.rm(path);
        }
    }
}

