/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb2;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.GenericFileName;

public class Smb2FileName
extends GenericFileName {
    private final String shareName;
    private String rootUri;
    private String uri;

    protected Smb2FileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type, String shareName) {
        super(scheme, hostName, port, defaultPort, userName, password, path, type);
        this.shareName = shareName;
        this.createURI();
    }

    public String getShareName() {
        return this.shareName;
    }

    @Override
    public String getFriendlyURI() {
        return this.createURI(false);
    }

    @Override
    public String getURI() {
        if (this.uri == null) {
            this.uri = this.createURI();
        }
        return this.uri;
    }

    @Override
    protected String createURI() {
        return this.createURI(true);
    }

    private String createURI(boolean usePassword) {
        StringBuilder sb = new StringBuilder();
        this.appendRootUri(sb, usePassword);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(this.shareName);
        String path = this.getPath();
        if (path != null && !path.equals("/")) {
            if (!path.startsWith("/")) {
                sb.append('/');
            }
            sb.append(path);
        }
        return sb.toString();
    }

    @Override
    public String getRootURI() {
        if (this.rootUri == null) {
            String uri = super.getRootURI();
            this.rootUri = uri + this.shareName;
        }
        return this.rootUri;
    }

    @Override
    public FileName getParent() {
        String path;
        if (this.rootUri == null) {
            this.getRootURI();
        }
        if ((path = this.getPath()).replaceAll("/", "").equals(this.shareName) || path.equals("/") || path.equals("")) {
            return null;
        }
        return new Smb2FileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), path.substring(0, path.lastIndexOf("/")), this.getType(), this.shareName);
    }
}

