/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.remotefilesystem.server.connector.contractimpl;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.server.RemoteFileSystemConsumer;
import org.wso2.transport.remotefilesystem.server.connector.contract.RemoteFileSystemServerConnector;

public class RemoteFileSystemServerConnectorImpl
implements RemoteFileSystemServerConnector {
    private static final Logger log = LoggerFactory.getLogger(RemoteFileSystemServerConnectorImpl.class);
    private RemoteFileSystemConsumer consumer;
    private String id;

    public RemoteFileSystemServerConnectorImpl(String id, Map<String, String> properties, RemoteFileSystemListener remoteFileSystemListener) throws RemoteFileSystemConnectorException {
        this.id = id;
        try {
            this.consumer = new RemoteFileSystemConsumer(id, properties, remoteFileSystemListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new RemoteFileSystemConnectorException("Failed to initialize File server connector for Service: " + id, e);
        }
    }

    @Override
    public void poll() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Poll method invoke for " + this.id);
            }
            this.consumer.consume();
        }
        catch (RemoteFileSystemConnectorException e) {
            log.error("Error executing the polling cycle of RemoteFileSystemServer for service: " + this.id, (Throwable)e);
        }
    }
}

