/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.Attribute;
import java.text.SimpleDateFormat;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

@Extension(name="lastModifiedTime", namespace="file", description="Checks for the last modified time for a given file path", parameters={@Parameter(name="uri", description="File path to be checked for te last modified time.", type={DataType.STRING}, dynamic=true), @Parameter(name="datetime.format", description="Format of the last modified datetime to be returned.", type={DataType.STRING}, optional=true, defaultValue="MM/dd/yyyy HH:mm:ss"), @Parameter(name="file.system.options", description="The file options in key:value pairs separated by commas. \neg:'USER_DIR_IS_ROOT:false,PASSIVE_MODE:true,AVOID_PERMISSION_CHECK:true,IDENTITY:file://demo/.ssh/id_rsa,IDENTITY_PASS_PHRASE:wso2carbon'\nNote: when IDENTITY is used, use a RSA PRIVATE KEY", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>")}, parameterOverloads={@ParameterOverload(parameterNames={"uri"}), @ParameterOverload(parameterNames={"uri", "datetime.format"}), @ParameterOverload(parameterNames={"uri", "datetime.format", "file.system.options"})}, returnAttributes={@ReturnAttribute(description="Last modified date time of a file in the given format.", type={DataType.STRING})}, examples={@Example(syntax="file:lastModifiedTime(filePath) as lastModifiedTime", description="Last modified datetime of a file will be returned as an string in MM/dd/yyyy HH:mm:ss."), @Example(syntax="file:lastModifiedTime(filePath, dd/MM/yyyy HH:mm:ss) as lastModifiedTime", description="Last modified datetime of a file will be returned as an string in 'dd/MM/yyyy HH:mm:ss' format.")})
public class FileLastModifiedTimeExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private Attribute.Type returnType = Attribute.Type.STRING;
    private SimpleDateFormat simpleDateFormat = null;
    private int inputExecutorLength;
    private String fileSystemOptions = null;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (this.inputExecutorLength == 1) {
            this.simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        }
        if (this.inputExecutorLength >= 2 && attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor) {
            String dataFormatString = ((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue().toString();
            this.simpleDateFormat = !dataFormatString.trim().isEmpty() ? new SimpleDateFormat(dataFormatString) : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        }
        if (this.inputExecutorLength == 3 && attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor) {
            this.fileSystemOptions = ((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue().toString();
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        String sourceFileUri = (String)data[0];
        if (this.inputExecutorLength == 2 && this.simpleDateFormat == null) {
            String pattern = (String)data[1];
            if (pattern != null && !pattern.isEmpty()) {
                try {
                    this.simpleDateFormat = new SimpleDateFormat(pattern);
                }
                catch (IllegalArgumentException e) {
                    throw new SiddhiAppRuntimeException("Illegal pattern: " + pattern + ", given to the datetime pattern ", (Throwable)e);
                }
            } else {
                throw new SiddhiAppRuntimeException("Exception occurred when getting datetime pattern. Pattern is either null or empty " + sourceFileUri);
            }
        }
        try {
            FileObject fileObj = Utils.getFileObject(sourceFileUri, this.fileSystemOptions);
            return this.simpleDateFormat.format(fileObj.getContent().getLastModifiedTime());
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when getting the last modified datetime of " + sourceFileUri, (Throwable)e);
        }
    }

    protected Object execute(Object data, State state) {
        String sourceFileUri = (String)data;
        try {
            FileObject fileObj = Utils.getFileObject(sourceFileUri, this.fileSystemOptions);
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            return sdf.format(fileObj.getContent().getLastModifiedTime());
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when getting the last modified datetime of " + sourceFileUri, (Throwable)e);
        }
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

