/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="searchInArchive", namespace="file", description="This.", parameters={@Parameter(name="uri", description="Absolute file path of the zip or tar file.", type={DataType.STRING}, dynamic=true), @Parameter(name="include.by.regexp", description="Only the files matching the patterns will be searched.\nNote: Add an empty string to match all files", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>"), @Parameter(name="file.system.options", description="The file options in key:value pairs separated by commas. \neg:'USER_DIR_IS_ROOT:false,PASSIVE_MODE:true,AVOID_PERMISSION_CHECK:true,IDENTITY:file://demo/.ssh/id_rsa,IDENTITY_PASS_PHRASE:wso2carbon'\nNote: when IDENTITY is used, use a RSA PRIVATE KEY", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>")}, parameterOverloads={@ParameterOverload(parameterNames={"uri"}), @ParameterOverload(parameterNames={"uri", "include.by.regexp"}), @ParameterOverload(parameterNames={"uri", "include.by.regexp", "file.system.options"})}, returnAttributes={@ReturnAttribute(name="fileNameList", description="The list file names in the archived file.", type={DataType.OBJECT})}, examples={@Example(syntax="ListArchivedFileStream#file:listFilesInArchive(filePath)", description="Lists the files inside the compressed file in the given path."), @Example(syntax="ListArchivedFileStream#file:listFilesInArchive(filePath, '.*test3.txt$')", description="Filters file names adheres to the given regex and lists the files inside the compressed file in the given path.")})
public class FileSearchInArchiveExtension
extends StreamFunctionProcessor {
    private static final Logger log = LogManager.getLogger(FileSearchInArchiveExtension.class);
    private Pattern pattern = null;
    private int inputExecutorLength;
    private String fileSystemOptions = null;

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (this.inputExecutorLength == 4 && attributeExpressionExecutors[3] instanceof ConstantExpressionExecutor) {
            this.fileSystemOptions = ((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue().toString();
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public List<Attribute> getReturnAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("fileNameList", Attribute.Type.OBJECT));
        return attributes;
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    protected Object[] process(Object[] data) {
        String zipFilePathUri = (String)data[0];
        String regex = "";
        ArrayList<String> fileList = new ArrayList<String>();
        if (this.inputExecutorLength >= 2) {
            regex = (String)data[1];
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(regex);
        }
        ZipInputStream zip = null;
        TarArchiveInputStream tarInput = null;
        try {
            FileObject fileObj = Utils.getFileObject(zipFilePathUri, this.fileSystemOptions);
            if (fileObj.isFile()) {
                if (zipFilePathUri.endsWith("zip")) {
                    ZipEntry zipEntry;
                    InputStream input = fileObj.getContent().getInputStream();
                    zip = new ZipInputStream(input);
                    while ((zipEntry = zip.getNextEntry()) != null) {
                        if (zipEntry.isDirectory() || !this.pattern.matcher(zipEntry.getName()).lookingAt()) continue;
                        fileList.add(zipEntry.getName());
                    }
                } else if (zipFilePathUri.endsWith("tar")) {
                    TarArchiveEntry tarEntry;
                    tarInput = new TarArchiveInputStream(new FileInputStream(zipFilePathUri));
                    while ((tarEntry = tarInput.getNextTarEntry()) != null) {
                        if (tarEntry.isDirectory() || !this.pattern.matcher(tarEntry.getName()).lookingAt()) continue;
                        fileList.add(tarEntry.getName());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SiddhiAppRuntimeException("Error while processing file: " + zipFilePathUri + ". " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    log.error("IO exception occurred when closing zip input stream for file path:" + zipFilePathUri, (Throwable)e);
                }
            }
            if (tarInput != null) {
                try {
                    tarInput.close();
                }
                catch (IOException e) {
                    log.error("IO exception occurred when closing tar input stream for file path:" + zipFilePathUri, (Throwable)e);
                }
            }
        }
        return new Object[]{fileList};
    }

    protected Object[] process(Object data) {
        return this.process(new Object[]{data});
    }
}

