/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.tree;

import jcifs.Configuration;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.TreeConnectResponse;
import jcifs.internal.smb2.ServerMessageBlock2;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.util.SMBUtil;

public class Smb2TreeConnectResponse
extends ServerMessageBlock2Response
implements TreeConnectResponse {
    public static final byte SMB2_SHARE_TYPE_DISK = 1;
    public static final byte SMB2_SHARE_TYPE_PIPE = 2;
    public static final byte SMB2_SHARE_TYPE_PRINT = 3;
    public static final int SMB2_SHAREFLAG_MANUAL_CACHING = 0;
    public static final int SMB2_SHAREFLAG_AUTO_CACHING = 16;
    public static final int SMB2_SHAREFLAG_VDO_CACHING = 32;
    public static final int SMB2_SHAREFLAG_DFS = 1;
    public static final int SMB2_SHAREFLAG_DFS_ROOT = 2;
    public static final int SMB2_SHAREFLAG_RESTRICT_EXCLUSIVE_OPENS = 256;
    public static final int SMB2_SHAREFLAG_FORCE_SHARED_DELETE = 512;
    public static final int SMB2_SHAREFLAG_ALLOW_NAMESPACE_CACHING = 1024;
    public static final int SMB2_SHAREFLAG_ACCESS_BASED_DIRECTORY_ENUM = 2048;
    public static final int SMB2_SHAREFLAG_FORCE_LEVEL2_OPLOCK = 4096;
    public static final int SMB2_SHAREFLAG_ENABLE_HASH_V1 = 8192;
    public static final int SMB2_SHAREFLAG_ENABLE_HASH_V2 = 16384;
    public static final int SMB2_SHAREFLAG_ENCRYPT_DATA = 32768;
    public static final int SMB2_SHARE_CAP_DFS = 8;
    public static final int SMB2_SHARE_CAP_CONTINUOUS_AVAILABILITY = 16;
    public static final int SMB2_SHARE_CAP_SCALEOUT = 32;
    public static final int SMB2_SHARE_CAP_CLUSTER = 64;
    public static final int SMB2_SHARE_CAP_ASYMMETRIC = 128;
    private byte shareType;
    private int shareFlags;
    private int capabilities;
    private int maximalAccess;

    public Smb2TreeConnectResponse(Configuration config) {
        super(config);
    }

    @Override
    public void prepare(CommonServerMessageBlockRequest next) {
        if (this.isReceived()) {
            ((ServerMessageBlock2)((Object)next)).setTreeId(this.getTreeId());
        }
        super.prepare(next);
    }

    public byte getShareType() {
        return this.shareType;
    }

    public int getShareFlags() {
        return this.shareFlags;
    }

    public int getCapabilities() {
        return this.capabilities;
    }

    public int getMaximalAccess() {
        return this.maximalAccess;
    }

    @Override
    public final int getTid() {
        return this.getTreeId();
    }

    @Override
    public boolean isValidTid() {
        return this.getTreeId() != 0;
    }

    @Override
    public String getService() {
        return null;
    }

    @Override
    public boolean isShareDfs() {
        return (this.shareFlags & 3) != 0 || (this.capabilities & 8) == 8;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 16) {
            throw new SMBProtocolDecodingException("Structure size is not 16");
        }
        this.shareType = buffer[bufferIndex + 2];
        this.shareFlags = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.capabilities = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.maximalAccess = SMBUtil.readInt4(buffer, bufferIndex += 4);
        return (bufferIndex += 4) - start;
    }
}

