/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import jcifs.spnego.SpnegoToken;
import jcifs.util.Hexdump;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class NegTokenInit
extends SpnegoToken {
    public static final int DELEGATION = 128;
    public static final int MUTUAL_AUTHENTICATION = 64;
    public static final int REPLAY_DETECTION = 32;
    public static final int SEQUENCE_CHECKING = 16;
    public static final int ANONYMITY = 8;
    public static final int CONFIDENTIALITY = 4;
    public static final int INTEGRITY = 2;
    private static final ASN1ObjectIdentifier SPNEGO_OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.2");
    private ASN1ObjectIdentifier[] mechanisms;
    private int contextFlags;

    public NegTokenInit() {
    }

    public NegTokenInit(ASN1ObjectIdentifier[] mechanisms, int contextFlags, byte[] mechanismToken, byte[] mechanismListMIC) {
        this.setMechanisms(mechanisms);
        this.setContextFlags(contextFlags);
        this.setMechanismToken(mechanismToken);
        this.setMechanismListMIC(mechanismListMIC);
    }

    public NegTokenInit(byte[] token) throws IOException {
        this.parse(token);
    }

    public int getContextFlags() {
        return this.contextFlags;
    }

    public void setContextFlags(int contextFlags) {
        this.contextFlags = contextFlags;
    }

    public boolean getContextFlag(int flag) {
        return (this.getContextFlags() & flag) == flag;
    }

    public void setContextFlag(int flag, boolean value) {
        this.setContextFlags(value ? this.getContextFlags() | flag : this.getContextFlags() & (0xFFFFFFFF ^ flag));
    }

    public ASN1ObjectIdentifier[] getMechanisms() {
        return this.mechanisms;
    }

    public void setMechanisms(ASN1ObjectIdentifier[] mechanisms) {
        this.mechanisms = mechanisms;
    }

    public String toString() {
        String mic = null;
        if (this.getMechanismListMIC() != null) {
            mic = Hexdump.toHexString(this.getMechanismListMIC(), 0, this.getMechanismListMIC().length);
        }
        return String.format("NegTokenInit[flags=%d,mechs=%s,mic=%s]", this.getContextFlags(), Arrays.toString(this.getMechanisms()), mic);
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] mechanismListMIC;
            byte[] mechanismToken;
            int ctxFlags;
            ASN1EncodableVector fields = new ASN1EncodableVector();
            ASN1ObjectIdentifier[] mechs = this.getMechanisms();
            if (mechs != null) {
                ASN1EncodableVector vector = new ASN1EncodableVector();
                for (int i = 0; i < mechs.length; ++i) {
                    vector.add(mechs[i]);
                }
                fields.add(new DERTaggedObject(true, 0, new DERSequence(vector)));
            }
            if ((ctxFlags = this.getContextFlags()) != 0) {
                fields.add(new DERTaggedObject(true, 1, new DERBitString(ctxFlags)));
            }
            if ((mechanismToken = this.getMechanismToken()) != null) {
                fields.add(new DERTaggedObject(true, 2, new DEROctetString(mechanismToken)));
            }
            if ((mechanismListMIC = this.getMechanismListMIC()) != null) {
                fields.add(new DERTaggedObject(true, 3, new DEROctetString(mechanismListMIC)));
            }
            ASN1EncodableVector ev = new ASN1EncodableVector();
            ev.add(SPNEGO_OID);
            ev.add(new DERTaggedObject(true, 0, new DERSequence(fields)));
            ByteArrayOutputStream collector = new ByteArrayOutputStream();
            ASN1OutputStream der = ASN1OutputStream.create(collector, "DER");
            DERApplicationSpecific derApplicationSpecific = new DERApplicationSpecific(0, ev);
            der.writeObject(derApplicationSpecific);
            return collector.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    @Override
    protected void parse(byte[] token) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream(token);){
            ASN1ApplicationSpecific constructed = (ASN1ApplicationSpecific)is.readObject();
            if (constructed == null || !constructed.isConstructed()) {
                throw new IOException("Malformed SPNEGO token " + constructed + (constructed != null ? " " + constructed.isConstructed() + " " + constructed.getApplicationTag() : ""));
            }
            try (ASN1InputStream der = new ASN1InputStream(constructed.getContents());){
                ASN1ObjectIdentifier spnego = (ASN1ObjectIdentifier)der.readObject();
                if (!SPNEGO_OID.equals(spnego)) {
                    throw new IOException("Malformed SPNEGO token, OID " + spnego);
                }
                ASN1TaggedObject tagged = (ASN1TaggedObject)der.readObject();
                if (tagged.getTagNo() != 0) {
                    throw new IOException("Malformed SPNEGO token: tag " + tagged.getTagNo() + " " + tagged);
                }
                ASN1Sequence sequence = ASN1Sequence.getInstance(tagged, true);
                Enumeration fields = sequence.getObjects();
                block17: while (fields.hasMoreElements()) {
                    tagged = (ASN1TaggedObject)fields.nextElement();
                    switch (tagged.getTagNo()) {
                        case 0: {
                            sequence = ASN1Sequence.getInstance(tagged, true);
                            ASN1ObjectIdentifier[] mechs = new ASN1ObjectIdentifier[sequence.size()];
                            for (int i = mechs.length - 1; i >= 0; --i) {
                                mechs[i] = (ASN1ObjectIdentifier)sequence.getObjectAt(i);
                            }
                            this.setMechanisms(mechs);
                            continue block17;
                        }
                        case 1: {
                            DERBitString ctxFlags = DERBitString.getInstance(tagged, true);
                            this.setContextFlags(ctxFlags.getBytes()[0] & 0xFF);
                            continue block17;
                        }
                        case 2: {
                            ASN1OctetString mechanismToken = ASN1OctetString.getInstance(tagged, true);
                            this.setMechanismToken(mechanismToken.getOctets());
                            continue block17;
                        }
                        case 3: {
                            if (!(tagged.getObject() instanceof DEROctetString)) continue block17;
                        }
                        case 4: {
                            ASN1OctetString mechanismListMIC = ASN1OctetString.getInstance(tagged, true);
                            this.setMechanismListMIC(mechanismListMIC.getOctets());
                            continue block17;
                        }
                    }
                    throw new IOException("Malformed token field.");
                }
            }
        }
    }
}

