/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb2;

import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.share.DiskEntry;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.smb2.Smb2ClientWrapper;
import org.apache.commons.vfs2.provider.smb2.Smb2FileObject;
import org.apache.commons.vfs2.provider.smb2.Smb2FileProvider;

public class Smb2FileSystem
extends AbstractFileSystem {
    private final AtomicReference<SMBClient> client = new AtomicReference();

    protected Smb2FileSystem(FileName rootName, FileSystemOptions fileSystemOptions, SMBClient smbClient) {
        super(rootName, null, fileSystemOptions);
        this.client.set(smbClient);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) {
        return new Smb2FileObject(name, this, this.getRootName());
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(Smb2FileProvider.capabilities);
    }

    public SMBClient getClient() {
        return this.client.getAndSet(null);
    }

    public void putClient(SMBClient smbClient) {
        this.client.set(smbClient);
    }

    public DiskEntry getDiskEntryWrite(String path, boolean bAppend) {
        return ((Smb2ClientWrapper)this.client.get()).getDiskEntryWrite(path, bAppend);
    }

    public DiskEntry getDiskEntryRead(String path) {
        return ((Smb2ClientWrapper)this.client.get()).getDiskEntryRead(path);
    }

    public DiskEntry getDiskEntryFolderWrite(String path) {
        return ((Smb2ClientWrapper)this.client.get()).getDiskEntryFolderWrite(path);
    }
}

