/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.io.file.metrics.FileDeleteMetrics;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

@Extension(name="delete", namespace="file", description="Deletes file/files in a particular path", parameters={@Parameter(name="uri", description="Absolute path of the file or the directory to be deleted.", type={DataType.STRING}, dynamic=true), @Parameter(name="file.system.options", description="The file options in key:value pairs separated by commas. \neg:'USER_DIR_IS_ROOT:false,PASSIVE_MODE:true,AVOID_PERMISSION_CHECK:true,IDENTITY:file://demo/.ssh/id_rsa,IDENTITY_PASS_PHRASE:wso2carbon'\nNote: when IDENTITY is used, use a RSA PRIVATE KEY", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>")}, parameterOverloads={@ParameterOverload(parameterNames={"uri"}), @ParameterOverload(parameterNames={"uri", "file.system.options"})}, examples={@Example(syntax="from DeleteFileStream#file:delete('/User/wso2/source/test.txt')", description="Deletes the file in the given path. "), @Example(syntax="from DeleteFileStream#file:delete('/User/wso2/source/')", description="Deletes the folder in the given path. ")})
public class FileDeleteExtension
extends StreamFunctionProcessor {
    private static final Logger log = LogManager.getLogger(FileDeleteExtension.class);
    private FileDeleteMetrics fileDeleteMetrics;
    private int inputExecutorLength;
    private String fileSystemOptions = null;

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (this.inputExecutorLength == 2 && attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor) {
            this.fileSystemOptions = ((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue().toString();
        }
        if (MetricsDataHolder.getInstance().getMetricService() != null && MetricsDataHolder.getInstance().getMetricManagementService().isEnabled()) {
            try {
                if (MetricsDataHolder.getInstance().getMetricManagementService().isReporterRunning("prometheus")) {
                    String siddhiAppName = siddhiQueryContext.getSiddhiAppContext().getName();
                    this.fileDeleteMetrics = new FileDeleteMetrics(siddhiAppName);
                }
            }
            catch (IllegalArgumentException e) {
                log.debug("Prometheus reporter is not running. Hence file metrics will not be initialized.");
            }
        }
        return null;
    }

    public List<Attribute> getReturnAttributes() {
        return new ArrayList<Attribute>();
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    protected Object[] process(Object[] data) {
        return this.deleteFileOrFolder((String)data[0]);
    }

    protected Object[] process(Object data) {
        return this.deleteFileOrFolder((String)data);
    }

    private Object[] deleteFileOrFolder(String fileDeletePathUri) {
        if (this.fileDeleteMetrics != null) {
            this.fileDeleteMetrics.setSource(fileDeletePathUri);
            this.fileDeleteMetrics.setTime(System.currentTimeMillis());
        }
        try {
            FileObject rootFileObject = Utils.getFileObject(fileDeletePathUri, this.fileSystemOptions);
            rootFileObject.delete(Selectors.SELECT_ALL);
            if (this.fileDeleteMetrics != null) {
                this.fileDeleteMetrics.getDeleteMetric(1);
            }
        }
        catch (FileSystemException e) {
            if (this.fileDeleteMetrics != null) {
                this.fileDeleteMetrics.getDeleteMetric(0);
            }
            throw new SiddhiAppRuntimeException("Failure occurred when deleting the file " + fileDeletePathUri, (Throwable)e);
        }
        return new Object[0];
    }

    public void start() {
    }

    public void stop() {
    }
}

