/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.Attribute;
import org.apache.commons.vfs2.FileSystemException;

@Extension(name="isDirectory", namespace="file", description="This function checks for a given file path points to a directory", parameters={@Parameter(name="uri", description="The path to be checked for a directory.", type={DataType.STRING}, dynamic=true), @Parameter(name="file.system.options", description="The file options in key:value pairs separated by commas. \neg:'USER_DIR_IS_ROOT:false,PASSIVE_MODE:true,AVOID_PERMISSION_CHECK:true,IDENTITY:file://demo/.ssh/id_rsa,IDENTITY_PASS_PHRASE:wso2carbon'\nNote: when IDENTITY is used, use a RSA PRIVATE KEY", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>")}, parameterOverloads={@ParameterOverload(parameterNames={"uri"}), @ParameterOverload(parameterNames={"uri", "file.system.options"})}, returnAttributes={@ReturnAttribute(description="Value will be set to true if the directory exists in the given path. False if otherwise.", type={DataType.BOOL})}, examples={@Example(syntax="file:isDirectory(filePath) as isDirectory", description="Checks whether the given path is a directory. Result will be returned as an boolean.")})
public class FileIsDirectoryExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private Attribute.Type returnType = Attribute.Type.BOOL;
    private String fileSystemOptions = null;
    private int inputExecutorLength;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (this.inputExecutorLength == 2 && attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor) {
            this.fileSystemOptions = ((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue().toString();
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return this.isDirectory((String)data[0]);
    }

    protected Object execute(Object data, State state) {
        return this.isDirectory((String)data);
    }

    private Object isDirectory(String filePathUri) {
        try {
            return Utils.getFileObject(filePathUri, this.fileSystemOptions).isFolder();
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when checking type of file in path: " + filePathUri, (Throwable)e);
        }
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

