/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="search", namespace="file", description="Searches files in a given folder and lists.", parameters={@Parameter(name="uri", description="Absolute file path of the directory.", type={DataType.STRING}, dynamic=true), @Parameter(name="include.by.regexp", description="Only the files matching the patterns will be searched.\nNote: Add an empty string to match all files", type={DataType.STRING}, optional=true, dynamic=true, defaultValue="<Empty_String>"), @Parameter(name="exclude.subdirectories", description="This flag is used to exclude the files un subdirectories when listing.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="file.system.options", description="The file options in key:value pairs separated by commas. \neg:'USER_DIR_IS_ROOT:false,PASSIVE_MODE:true,AVOID_PERMISSION_CHECK:true,IDENTITY:file://demo/.ssh/id_rsa,IDENTITY_PASS_PHRASE:wso2carbon'\nNote: when IDENTITY is used, use a RSA PRIVATE KEY", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>")}, parameterOverloads={@ParameterOverload(parameterNames={"uri"}), @ParameterOverload(parameterNames={"uri", "include.by.regexp"}), @ParameterOverload(parameterNames={"uri", "include.by.regexp", "exclude.subdirectories"}), @ParameterOverload(parameterNames={"uri", "include.by.regexp", "exclude.subdirectories", "file.system.options"})}, returnAttributes={@ReturnAttribute(name="fileNameList", description="The lit file name matches in the directory.", type={DataType.OBJECT})}, examples={@Example(syntax="ListFileStream#file:search(filePath)", description="This will list all the files (also in sub-folders) in a given path."), @Example(syntax="ListFileStream#file:search(filePath, '.*test3.txt$')", description="This will list all the files (also in sub-folders) which adheres to a given regex file pattern in a given path."), @Example(syntax="ListFileStream#file:search(filePath, '.*test3.txt$', true)", description="This will list all the files excluding the files in sub-folders which adheres to a given regex file pattern in a given path.")})
public class FileSearchExtension
extends StreamFunctionProcessor {
    private static final Logger log = LogManager.getLogger(FileSearchExtension.class);
    private Pattern pattern = null;
    private int inputExecutorLength;
    private boolean excludeSubdirectories = false;
    private String fileSystemOptions = null;

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (this.inputExecutorLength >= 2 && attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor) {
            this.pattern = Pattern.compile(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue().toString());
        }
        if (this.inputExecutorLength == 4 && attributeExpressionExecutors[3] instanceof ConstantExpressionExecutor) {
            this.fileSystemOptions = ((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue().toString();
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public List<Attribute> getReturnAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("fileNameList", Attribute.Type.OBJECT));
        return attributes;
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    protected Object[] process(Object[] data) {
        ArrayList<String> fileList;
        block17: {
            fileList = new ArrayList<String>();
            String sourceFileUri = (String)data[0];
            String regex = "";
            if (this.inputExecutorLength >= 2) {
                regex = (String)data[1];
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile(regex);
            }
            if (this.inputExecutorLength == 3) {
                this.excludeSubdirectories = (Boolean)data[2];
            }
            try {
                FileObject[] children;
                FileObject fileObj = Utils.getFileObject(sourceFileUri, this.fileSystemOptions);
                if (!fileObj.exists()) break block17;
                for (FileObject child : children = fileObj.getChildren()) {
                    try {
                        if (child.getType() == FileType.FILE && (this.pattern.matcher(child.getName().getBaseName()).lookingAt() || this.pattern.toString().isEmpty())) {
                            fileList.add(this.getFilePath(child.getName()));
                            continue;
                        }
                        if (child.getType() != FileType.FOLDER) continue;
                        this.searchSubFolders(child, fileList);
                    }
                    catch (IOException e) {
                        throw new SiddhiAppRuntimeException("Unable to search a file with pattern" + this.pattern.toString() + " in " + sourceFileUri, (Throwable)e);
                    }
                    finally {
                        try {
                            if (child != null) {
                                child.close();
                            }
                        }
                        catch (IOException e) {
                            log.error("Error while closing Directory: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                throw new SiddhiAppRuntimeException("Exception occurred when getting the searching files in path " + sourceFileUri, (Throwable)e);
            }
        }
        return new Object[]{fileList};
    }

    protected Object[] process(Object data) {
        return this.process(new Object[]{data});
    }

    private String getFilePath(FileName fileName) {
        if (fileName instanceof LocalFileName) {
            LocalFileName localFileName = (LocalFileName)fileName;
            return localFileName.getRootFile() + localFileName.getPath();
        }
        return fileName.getPath();
    }

    private void searchSubFolders(FileObject child, List<String> fileList) {
        ArrayList<FileObject> fileObjectList = new ArrayList<FileObject>();
        this.getAllFiles(child, fileObjectList);
        try {
            for (FileObject file : fileObjectList) {
                if (file.getType() == FileType.FILE && (this.pattern.matcher(file.getName().getBaseName().toLowerCase(Locale.ENGLISH)).lookingAt() || this.pattern.toString().isEmpty())) {
                    fileList.add(this.getFilePath(file.getName()));
                    continue;
                }
                if (file.getType() != FileType.FOLDER || this.excludeSubdirectories) continue;
                this.searchSubFolders(file, fileList);
            }
        }
        catch (IOException e) {
            throw new SiddhiAppRuntimeException("Unable to search a file with pattern" + this.pattern.toString() + " in " + child.getName().getPath() + ". " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                child.close();
            }
            catch (IOException e) {
                log.error("Error while closing Directory: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void getAllFiles(FileObject dir, List<FileObject> fileList) {
        try {
            FileObject[] children = dir.getChildren();
            fileList.addAll(Arrays.asList(children));
        }
        catch (IOException e) {
            throw new SiddhiAppRuntimeException("Unable to list all files when searching files with pattern. " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (dir != null) {
                    dir.close();
                }
            }
            catch (IOException e) {
                log.error("Error while closing Directory: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

