/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.file.util;

import io.siddhi.core.event.Event;
import io.siddhi.extension.io.file.util.FileSourceConfiguration;
import io.siddhi.extension.io.file.util.Status;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final Logger log = LogManager.getLogger(Util.class);

    public static Event getFileHandlerEvent(File file, List<String> fileObjectList, Status enumStatus) {
        String status;
        boolean listenerEventsURLValidated = false;
        switch (enumStatus) {
            case STATUS_NEW: {
                status = "created";
                break;
            }
            case STATUS_PROCESS: {
                status = "modifying";
                break;
            }
            case STATUS_DONE: {
                status = "modifyingCompleted";
                break;
            }
            case STATUS_REMOVE: {
                status = "removed";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)enumStatus));
            }
        }
        if (fileObjectList.contains(file.getAbsolutePath())) {
            listenerEventsURLValidated = true;
        } else {
            for (String fileObjectPath : fileObjectList) {
                File fileObject = new File(fileObjectPath);
                if (!fileObject.isDirectory()) continue;
                listenerEventsURLValidated = true;
            }
        }
        if (listenerEventsURLValidated) {
            Object[] obj = new Object[]{file.getAbsolutePath(), file.getName(), status};
            return new Event(System.currentTimeMillis(), obj);
        }
        return null;
    }

    public static String getFileName(String uri, String protocol) {
        try {
            URL url = new URL(String.format("%s%s%s", protocol, File.separator, uri));
            return FilenameUtils.getName((String)url.getPath());
        }
        catch (MalformedURLException e) {
            log.error(String.format("Failed to extract file name from the uri '%s '.", uri), (Throwable)e);
            return null;
        }
    }

    public static String constructPath(String baseUri, String fileName) {
        if (baseUri != null && fileName != null) {
            if (baseUri.endsWith(File.separator)) {
                return String.format("%s%s", baseUri, fileName);
            }
            return String.format("%s%s%s", baseUri, File.separator, fileName);
        }
        return null;
    }

    public static Map<String, String> generateProperties(FileSourceConfiguration fileSourceConfiguration, String fileURI) {
        HashMap<String, String> properties;
        String mode = fileSourceConfiguration.getMode();
        if ("text.full".equalsIgnoreCase(mode)) {
            properties = new HashMap<String, String>();
            properties.put("uri", fileURI);
            properties.put("readFromBeginning", "true");
            properties.put("action", "read");
            properties.put("pollingInterval", fileSourceConfiguration.getFilePollingInterval());
            properties.put("fileReadWaitTimeout", fileSourceConfiguration.getFileReadWaitTimeout());
            properties.put("mode", mode);
            properties.put("cron.expression", fileSourceConfiguration.getCronExpression());
        } else if ("binary.full".equalsIgnoreCase(mode) || "binary.chunked".equalsIgnoreCase(mode)) {
            properties = new HashMap();
            properties.put("uri", fileURI);
            properties.put("readFromBeginning", "true");
            properties.put("action", "read");
            properties.put("pollingInterval", fileSourceConfiguration.getFilePollingInterval());
            properties.put("fileReadWaitTimeout", fileSourceConfiguration.getFileReadWaitTimeout());
            properties.put("mode", mode);
            properties.put("cron.expression", fileSourceConfiguration.getCronExpression());
            properties.put("buffer.size", fileSourceConfiguration.getBufferSize());
        } else {
            properties = new HashMap();
            properties.put("action", "read");
            properties.put("maxLinesPerPoll", "10");
            properties.put("pollingInterval", fileSourceConfiguration.getFilePollingInterval());
            properties.put("fileReadWaitTimeout", fileSourceConfiguration.getFileReadWaitTimeout());
            properties.put("mode", mode);
            properties.put("header.present", fileSourceConfiguration.getHeaderPresent());
            properties.put("read.only.header", fileSourceConfiguration.getReadOnlyHeader());
            properties.put("read.only.trailer", fileSourceConfiguration.getReadOnlyTrailer());
            properties.put("skip.trailer", fileSourceConfiguration.getSkipTrailer());
            properties.put("cron.expression", fileSourceConfiguration.getCronExpression());
            properties.put("uri", fileURI);
        }
        return properties;
    }

    public static Map<String, String> reProcessFileGenerateProperties(FileSourceConfiguration fileSourceConfiguration, String fileURI, Map<String, String> properties) {
        String actionAfterProcess = fileSourceConfiguration.getActionAfterProcess();
        properties.put("uri", fileURI);
        properties.put("ackTimeOut", "1000");
        properties.put("action", actionAfterProcess);
        if (actionAfterProcess.equalsIgnoreCase("move")) {
            properties.put("move.if.exist.mode", fileSourceConfiguration.getMoveIfExistMode());
        }
        return properties;
    }
}

