/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.util;

import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.extension.io.file.metrics.Metrics;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.log4j.Logger;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.server.util.FileTransportUtils;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);

    public static FileObject getFileObject(String filePathUri, String fileSystemOptions) {
        Map<String, String> fileSystemOptionMap = Utils.getFileSystemOptionMap(filePathUri, fileSystemOptions);
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileSystemOptions sourceFso = FileTransportUtils.attachFileSystemOptions(fileSystemOptionMap);
            SftpFileSystemConfigBuilder configBuilder = SftpFileSystemConfigBuilder.getInstance();
            if (fileSystemOptionMap.get("session.timeout") != null) {
                configBuilder.setTimeout(sourceFso, Integer.parseInt(fileSystemOptionMap.get("session.timeout")));
                log.info((Object)("The session timeout was set successfully, the configured timeout is : " + fileSystemOptionMap.get("session.timeout")));
            }
            return fsManager.resolveFile(filePathUri, sourceFso);
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when getting VFS manager", (Throwable)e);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when parsing scheme file options for path: " + fileSystemOptionMap, (Throwable)e);
        }
    }

    public static Map<String, String> getFileSystemOptionMap(String filePathUri, String fileSystemOptions) {
        HashMap<String, String> fileSystemOptionMap = new HashMap<String, String>();
        String scheme = UriParser.extractScheme(filePathUri);
        if (scheme != null) {
            fileSystemOptionMap.put("VFS_SCHEME", scheme);
        }
        if (fileSystemOptions != null) {
            String[] configs;
            for (String config : configs = fileSystemOptions.split(",")) {
                String[] configKeyValue = config.split(":");
                fileSystemOptionMap.put(configKeyValue[0], configKeyValue[1]);
            }
        }
        fileSystemOptionMap.put("uri", filePathUri);
        return fileSystemOptionMap;
    }

    public static Map<String, Object> getFileSystemOptionObjectMap(String filePathUri, String fileSystemOptions) {
        String scheme;
        HashMap<String, Object> fileSystemOptionMap = new HashMap<String, Object>();
        if (filePathUri != null && (scheme = UriParser.extractScheme(filePathUri)) != null) {
            fileSystemOptionMap.put("VFS_SCHEME", scheme);
        }
        if (fileSystemOptions != null) {
            String[] configs;
            for (String config : configs = fileSystemOptions.split(",")) {
                String[] configKeyValue = config.split(":");
                fileSystemOptionMap.put(configKeyValue[0], configKeyValue[1]);
            }
        }
        fileSystemOptionMap.put("uri", filePathUri);
        return fileSystemOptionMap;
    }

    public static void generateFileList(FileObject node, List<FileObject> fileObjectList, boolean excludeSubdirectories) {
        try {
            FileObject[] subNote;
            if (node.isFile()) {
                fileObjectList.add(node);
            }
            if (node.isFolder() && !excludeSubdirectories && (subNote = node.getChildren()) != null) {
                for (FileObject file : subNote) {
                    Utils.generateFileList(file, fileObjectList, false);
                }
            }
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when checking file type for " + node.getName().getPath(), (Throwable)e);
        }
    }

    public static long getFileSize(String filePathUri) {
        filePathUri = Utils.getFilePath(filePathUri);
        File file = new File(filePathUri);
        return file.length();
    }

    private static String getFilePath(String uri) {
        if (uri.startsWith("file:")) {
            uri = uri.replaceFirst("file:", "");
        }
        uri = uri.replace("%20", " ");
        return FilenameUtils.separatorsToSystem((String)uri).replace("\\", "/");
    }

    /*
     * Exception decompiling
     */
    public static long getLinesCount(String uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String capitalizeFirstLetter(String str) {
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1);
    }

    public static String getFileName(String fileURI, Metrics metrics) {
        fileURI = Utils.getFilePath(fileURI);
        if (metrics.getFileNames().containsKey(fileURI)) {
            return metrics.getFileNames().get(fileURI);
        }
        String[] arr = fileURI.split("/");
        int n = arr.length;
        StringBuilder fileName = new StringBuilder();
        fileName.append(arr[n - 1]);
        if (!metrics.getFileNames().containsValue(fileName.toString())) {
            return fileName.toString();
        }
        for (int i = n - 2; i >= 0; --i) {
            fileName.insert(0, "/").insert(0, arr[i]);
            if (metrics.getFileNames().containsValue(fileName.toString())) continue;
            metrics.getFileNames().put(fileURI, fileName.toString());
            break;
        }
        return fileName.toString();
    }

    public static String getShortFilePath(String fileURI) {
        if ((fileURI = Utils.getFilePath(fileURI)).length() <= 40) {
            return fileURI;
        }
        int n = fileURI.length();
        int i = n - 41;
        char c = fileURI.charAt(i);
        while (c != '/' && i > 0) {
            c = fileURI.charAt(--i);
        }
        if (i == 0) {
            return fileURI;
        }
        return ".." + fileURI.substring(i);
    }

    private static /* synthetic */ boolean lambda$getLinesCount$0(String line) {
        return line.length() != 0;
    }
}

