/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.GenericFileName;

public class SmbFileName
extends GenericFileName {
    private static final int DEFAULT_PORT = 139;
    private final String share;
    private final String domain;
    private String uriWithoutAuth;

    protected SmbFileName(String scheme, String hostName, int port, String userName, String password, String domain, String share, String path, FileType type) {
        super(scheme, hostName, port, 139, userName, password, path, type);
        this.share = share;
        this.domain = domain;
    }

    public String getShare() {
        return this.share;
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        super.appendRootUri(buffer, addPassword);
        buffer.append('/');
        buffer.append(this.share);
    }

    @Override
    protected void appendCredentials(StringBuilder buffer, boolean addPassword) {
        if (this.getDomain() != null && this.getDomain().length() != 0 && this.getUserName() != null && this.getUserName().length() != 0) {
            buffer.append(this.getDomain());
            buffer.append("\\");
        }
        super.appendCredentials(buffer, addPassword);
    }

    @Override
    public FileName createName(String path, FileType type) {
        return new SmbFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getUserName(), this.getPassword(), this.domain, this.share, path, type);
    }

    public String getUriWithoutAuth() throws FileSystemException {
        if (this.uriWithoutAuth != null) {
            return this.uriWithoutAuth;
        }
        StringBuilder sb = new StringBuilder(120);
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getHostName());
        if (this.getPort() != 139) {
            sb.append(":");
            sb.append(this.getPort());
        }
        sb.append("/");
        sb.append(this.getShare());
        sb.append(this.getPathDecoded());
        this.uriWithoutAuth = sb.toString();
        return this.uriWithoutAuth;
    }

    public String getDomain() {
        return this.domain;
    }
}

