/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb2;

import java.net.URI;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.provider.smb2.Smb2FileName;

public class Smb2FileNameParser
extends HostFileNameParser {
    private static final Smb2FileNameParser INSTANCE = new Smb2FileNameParser();
    private static final int PORT = 445;

    protected Smb2FileNameParser() {
        super(445);
    }

    public static Smb2FileNameParser getInstance() {
        return INSTANCE;
    }

    protected String extractShareName(URI uri) throws FileSystemException {
        String path = uri.getPath();
        path = path.startsWith("/") ? path.substring(1) : path;
        String[] pathParts = path.split("/");
        String share = pathParts[0];
        if (share == null || share.isEmpty()) {
            throw new FileSystemException("vfs.provider.smb2/missing-share-name.error", (Object)uri.toString());
        }
        return pathParts[0];
    }

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        String relPathFromShare;
        FileName parsedFileName = super.parseUri(context, base, uri);
        String share = base == null ? this.extractShareName(this.parseURIString(parsedFileName.toString())) : this.extractShareName(this.parseURIString(base.toString()));
        StringBuilder sb = new StringBuilder();
        HostFileNameParser.Authority auth = this.extractToPath(parsedFileName.toString(), sb);
        String path = sb.length() == 0 || sb.length() == 1 && sb.charAt(0) == '/' ? "/" + share : parsedFileName.getPath();
        try {
            relPathFromShare = this.removeShareFromAbsPath(path, share);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.smb2/share-path-extraction.error", (Object)path, e.getCause());
        }
        return new Smb2FileName(auth.getScheme(), auth.getHostName(), auth.getPort(), 445, auth.getUserName(), auth.getPassword(), relPathFromShare, parsedFileName.getType(), share);
    }

    public URI parseURIString(String uriString) throws FileSystemException {
        try {
            return new URI(uriString);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", (Object)uriString, e.getCause());
        }
    }

    public String removeShareFromAbsPath(String path, String shareName) throws Exception {
        String modifiedPath;
        if (shareName == null || shareName.length() == 0) {
            throw new Exception("No path provided!");
        }
        String string = modifiedPath = path.startsWith("/") ? path.substring(1) : path;
        if (!modifiedPath.substring(0, shareName.length()).equals(shareName)) {
            throw new IllegalArgumentException("Share does not match the provided path");
        }
        if ((modifiedPath = modifiedPath.substring(shareName.length())).equals("") || modifiedPath.equals("/")) {
            return "";
        }
        return modifiedPath;
    }
}

