/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb2;

import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.smb2.Smb2ClientWrapper;
import org.apache.commons.vfs2.provider.smb2.Smb2FileSystem;
import org.apache.commons.vfs2.provider.smb2.Smb2InputStreamWrapper;

public class Smb2FileObject
extends AbstractFileObject<Smb2FileSystem> {
    private final String relPathToShare;
    private FileAllInformation fileInfo;
    private FileName rootName;
    private DiskEntry diskEntryWrite;
    private DiskEntry diskEntryRead;
    private DiskEntry diskEntryFolderWrite;

    protected Smb2FileObject(AbstractFileName name, Smb2FileSystem fileSystem, FileName rootName) {
        super(name, fileSystem);
        String relPath = name.getURI().substring(rootName.getURI().length());
        this.relPathToShare = relPath.startsWith("/") ? relPath.substring(1).replace("/", "\\") : relPath.replace("/", "\\");
        this.rootName = rootName;
    }

    @Override
    protected long doGetContentSize() throws Exception {
        this.getFileInfo();
        return this.fileInfo.getStandardInformation().getEndOfFile();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
        }
        if (this.diskEntryRead == null) {
            this.getDiskEntryRead();
        }
        InputStream is = ((File)this.diskEntryRead).getInputStream();
        return new Smb2InputStreamWrapper(is, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getFileInfo();
            }
            if (this.fileInfo == null) {
                return FileType.IMAGINARY;
            }
            return this.fileInfo.getStandardInformation().isDirectory() ? FileType.FOLDER : FileType.FILE;
        }
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileInfo() {
        if (this.fileInfo == null) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                Smb2FileSystem fileSystem2 = (Smb2FileSystem)this.getFileSystem();
                Smb2ClientWrapper client = (Smb2ClientWrapper)fileSystem2.getClient();
                try {
                    this.fileInfo = client.getFileInfo(this.getRelPathToShare());
                }
                finally {
                    fileSystem2.putClient(client);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject getParent() throws FileSystemException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            AbstractFileName name = (AbstractFileName)this.getName().getParent();
            if (name == null) {
                return null;
            }
            FileObject cachedFile = this.getFileSystem().getFileSystemManager().getFilesCache().getFile(this.getFileSystem(), name);
            if (cachedFile != null) {
                return cachedFile;
            }
            return new Smb2FileObject(name, (Smb2FileSystem)this.getFileSystem(), this.rootName);
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (this.diskEntryWrite == null) {
            this.getDiskEntryWrite(bAppend);
        }
        return ((File)this.diskEntryWrite).getOutputStream(bAppend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCreateFolder() throws Exception {
        try {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                Smb2FileSystem fileSystem2 = (Smb2FileSystem)this.getFileSystem();
                Smb2ClientWrapper client = (Smb2ClientWrapper)fileSystem2.getClient();
                try {
                    client.createFolder(this.getRelPathToShare());
                }
                finally {
                    fileSystem2.putClient(client);
                }
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.smb2/folder-create.error", (Object)this.getName(), e.getCause());
        }
    }

    @Override
    protected void endOutput() throws Exception {
        super.endOutput();
        this.closeAllHandles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDiskEntryWrite(boolean bAppend) throws FileSystemException {
        this.closeAllHandles();
        try {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                Smb2FileSystem fileSystem2 = (Smb2FileSystem)this.getFileSystem();
                this.diskEntryWrite = fileSystem2.getDiskEntryWrite(this.getRelPathToShare(), bAppend);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.smb2/diskentry-create.error", (Object)this.getName(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDiskEntryRead() throws FileSystemException {
        try {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                Smb2FileSystem fileSystem2 = (Smb2FileSystem)this.getFileSystem();
                this.diskEntryRead = fileSystem2.getDiskEntryRead(this.getRelPathToShare());
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.smb2/diskentry-create.error", (Object)this.getName(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDiskEntryFolderWrite() throws FileSystemException {
        try {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                Smb2FileSystem fileSystem2 = (Smb2FileSystem)this.getFileSystem();
                this.diskEntryFolderWrite = fileSystem2.getDiskEntryFolderWrite(this.getRelPathToShare());
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.smb2/diskentry-create.error", (Object)this.getName(), e.getCause());
        }
    }

    public String getRelPathToShare() {
        return this.decodeOrGet(this.relPathToShare);
    }

    public String decodeOrGet(String value) {
        try {
            return UriParser.decode(value);
        }
        catch (FileSystemException e) {
            return value;
        }
    }

    @Override
    protected void doRename(FileObject newFile) throws Exception {
        Smb2FileObject fileObject = (Smb2FileObject)newFile;
        if (this.doGetType() == FileType.FOLDER) {
            if (this.diskEntryFolderWrite == null) {
                this.getDiskEntryFolderWrite();
            }
            this.diskEntryFolderWrite.rename(fileObject.getRelPathToShare());
        } else {
            if (this.diskEntryWrite == null) {
                this.getDiskEntryWrite(false);
            }
            this.diskEntryWrite.rename(fileObject.getRelPathToShare());
            this.closeAllHandles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            String[] childrenNames;
            if (this.getType() != FileType.FOLDER) {
                throw new FileSystemException("vfs.provider/list-children-not-folder.error", (Object)this);
            }
            ArrayList<FileObject> children = new ArrayList<FileObject>();
            Smb2FileSystem fileSystem2 = (Smb2FileSystem)this.getFileSystem();
            Smb2ClientWrapper client = (Smb2ClientWrapper)fileSystem2.getClient();
            try {
                childrenNames = client.getChildren(this.getRelPathToShare());
            }
            finally {
                fileSystem2.putClient(client);
            }
            for (String child : childrenNames) {
                children.add(fileSystem2.getFileSystemManager().resolveFile(this, UriParser.encode(child)));
            }
            return children.toArray(new FileObject[children.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.diskEntryRead != null) {
                this.diskEntryRead.close();
            }
            this.endOutput();
            Smb2FileSystem fileSystem2 = (Smb2FileSystem)this.getFileSystem();
            Smb2ClientWrapper client = (Smb2ClientWrapper)fileSystem2.getClient();
            try {
                client.delete(this.getRelPathToShare());
            }
            finally {
                fileSystem2.putClient(client);
            }
        }
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        this.getFileInfo();
        return this.fileInfo.getBasicInformation().getChangeTime().getWindowsTimeStamp();
    }

    @Override
    public void close() throws FileSystemException {
        super.close();
        this.closeAllHandles();
    }

    private void closeAllHandles() {
        if (this.diskEntryRead != null) {
            this.diskEntryRead.close();
            this.diskEntryRead = null;
        }
        if (this.diskEntryWrite != null) {
            this.diskEntryWrite.close();
            this.diskEntryWrite = null;
        }
    }

    @Override
    protected void doDetach() {
        this.fileInfo = null;
    }

    @Override
    public String toString() {
        return this.getName().toString();
    }

    @Override
    public boolean doSetLastModifiedTime(long modTime) {
        return true;
    }
}

