/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.smb2.Smb2ClientWrapper;
import org.apache.commons.vfs2.provider.smb2.Smb2FileNameParser;
import org.apache.commons.vfs2.provider.smb2.Smb2FileSystem;

public class Smb2FileProvider
extends AbstractOriginatingFileProvider {
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT));

    public Smb2FileProvider() {
        this.setFileNameParser(Smb2FileNameParser.getInstance());
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        Smb2ClientWrapper smbClient = new Smb2ClientWrapper(rootName, fileSystemOptions);
        return new Smb2FileSystem((FileName)rootName, fileSystemOptions, smbClient);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    @Override
    public FileName parseUri(FileName base, String uri) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), base, uri);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }
}

