/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.file.connector.server.util;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;
import org.wso2.transport.file.connector.server.exception.FileServerConnectorException;
import org.wso2.transport.file.connector.server.util.Constants;

public class FileTransportUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");

    public static FileSystemOptions attachFileSystemOptions(Map<String, String> options, FileSystemManager fsManager) throws FileServerConnectorException {
        if (options == null) {
            return null;
        }
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delegate = new DelegatingFileSystemOptionsBuilder(fsManager);
        if ("sftp".equals(options.get("VFS_SCHEME"))) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                for (Constants.SftpFileOption option : Constants.SftpFileOption.values()) {
                    if (!entry.getKey().equals(option.toString()) || null == entry.getValue()) continue;
                    try {
                        delegate.setConfigString(opts, "sftp", entry.getKey().toLowerCase(Locale.US), entry.getValue());
                    }
                    catch (FileSystemException e) {
                        throw new FileServerConnectorException("Failed to set file transport configuration for scheme: sftp and option: " + option.toString(), e);
                    }
                }
            }
        }
        if (options.get("filetype") != null) {
            try {
                delegate.setConfigString(opts, options.get("VFS_SCHEME"), "filetype", String.valueOf(FileTransportUtils.getFileType(options.get("filetype"))));
            }
            catch (FileSystemException e) {
                throw new FileServerConnectorException("Failed to set file transport configuration for scheme: " + options.get("VFS_SCHEME") + " and option: " + "filetype", e);
            }
        }
        return opts;
    }

    public static String maskURLPassword(String url) {
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            Matcher pwdMatcher = PASSWORD_PATTERN.matcher(url);
            String maskUrl = pwdMatcher.replaceFirst("\":***@\"");
            return maskUrl;
        }
        return url;
    }

    private static Integer getFileType(String fileType) {
        return "ASCII".equals(fileType = fileType.toUpperCase(Locale.US)) ? Integer.valueOf(0) : ("BINARY".equals(fileType) ? Integer.valueOf(2) : ("EBCDIC".equals(fileType) ? Integer.valueOf(1) : ("LOCAL".equals(fileType) ? Integer.valueOf(3) : Integer.valueOf(2))));
    }
}

