/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.remotefilesystem.client.connector.contractimpl;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.remotefilesystem.client.connector.contract.FtpAction;
import org.wso2.transport.remotefilesystem.client.connector.contract.VFSClientConnector;
import org.wso2.transport.remotefilesystem.client.connector.contractimpl.FileObjectInputStream;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.message.FileInfo;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemMessage;
import org.wso2.transport.remotefilesystem.server.util.FileTransportUtils;

public class VFSClientConnectorImpl
implements VFSClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(VFSClientConnectorImpl.class);
    private Map<String, String> connectorConfig;
    private RemoteFileSystemListener remoteFileSystemListener;
    private FileSystemOptions opts;

    public VFSClientConnectorImpl(Map<String, String> config, RemoteFileSystemListener listener) throws RemoteFileSystemConnectorException {
        this.connectorConfig = config;
        this.remoteFileSystemListener = listener;
        this.opts = FileTransportUtils.attachFileSystemOptions(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void send(RemoteFileSystemMessage message, FtpAction action) {
        fileURI = this.connectorConfig.get("uri");
        outputStream = null;
        path = null;
        pathClose = true;
        try {
            fsManager = VFS.getManager();
            path = fsManager.resolveFile(fileURI, this.opts);
            switch (1.$SwitchMap$org$wso2$transport$remotefilesystem$client$connector$contract$FtpAction[action.ordinal()]) {
                case 1: {
                    if (path.exists()) {
                        throw new RemoteFileSystemConnectorException("Directory exists: " + path.getName().getURI());
                    }
                    path.createFolder();
                    break;
                }
                case 2: 
                case 3: {
                    if (!path.exists()) {
                        path.createFile();
                        path.refresh();
                    }
                    outputStream = FtpAction.APPEND.equals((Object)action) != false ? path.getContent().getOutputStream(true) : path.getContent().getOutputStream();
                    inputStream = message.getInputStream();
                    byteBuffer = message.getBytes();
                    if (byteBuffer != null) {
                        outputStream.write(byteBuffer.array());
                    } else if (inputStream != null) {
                        buffer = new byte[16384];
                        while ((n = inputStream.read(buffer)) > -1) {
                            outputStream.write(buffer, 0, n);
                        }
                    }
                    outputStream.flush();
                    break;
                }
                case 4: {
                    if (path.exists()) {
                        filesDeleted = path.delete(Selectors.SELECT_SELF);
                        if (!VFSClientConnectorImpl.logger.isDebugEnabled()) break;
                        VFSClientConnectorImpl.logger.debug(filesDeleted + " files successfully deleted");
                        break;
                    }
                    throw new RemoteFileSystemConnectorException("Failed to delete file: " + path.getName().getURI() + " not found");
                }
                case 5: {
                    if (path.exists()) {
                        filesDeleted = path.delete(Selectors.SELECT_ALL);
                        if (!VFSClientConnectorImpl.logger.isDebugEnabled()) break;
                        VFSClientConnectorImpl.logger.debug(filesDeleted + " files successfully deleted");
                        break;
                    }
                    throw new RemoteFileSystemConnectorException("Failed to delete directory: " + path.getName().getURI() + " not found");
                }
                case 6: {
                    if (!path.exists()) ** GOTO lbl117
                    destination = this.connectorConfig.get("destination");
                    newPath = fsManager.resolveFile(destination, this.opts);
                    var12_24 = null;
                    parent = newPath.getParent();
                    var14_30 = null;
                    try {
                        if (parent == null) ** GOTO lbl92
                        if (!parent.exists()) {
                            parent.createFolder();
                        }
                        finalPath = parent.resolveFile(newPath.getName().getBaseName());
                        var16_36 = null;
                        try {
                            if (finalPath.exists()) ** GOTO lbl63
                            path.moveTo(finalPath);
                            ** GOTO lbl92
lbl63:
                            // 1 sources

                            throw new RemoteFileSystemConnectorException("The file at " + newPath.getURL().toString() + " already exists or it is a directory");
                        }
                        catch (Throwable var17_39) {
                            var16_36 = var17_39;
                            throw var17_39;
                        }
                        finally {
                            if (finalPath != null) {
                                if (var16_36 != null) {
                                    try {
                                        finalPath.close();
                                    }
                                    catch (Throwable var17_38) {
                                        var16_36.addSuppressed(var17_38);
                                    }
                                } else {
                                    finalPath.close();
                                }
                            }
                        }
                    }
                    catch (Throwable finalPath) {
                        var14_30 = finalPath;
                        throw finalPath;
                    }
                    finally {
                        if (parent != null) {
                            if (var14_30 != null) {
                                try {
                                    parent.close();
                                }
                                catch (Throwable finalPath) {
                                    var14_30.addSuppressed(finalPath);
                                }
                            } else {
                                parent.close();
                            }
                        }
                    }
lbl92:
                    // 2 sources

                    if (newPath == null) break;
                    if (var12_24 == null) ** GOTO lbl100
                    try {
                        newPath.close();
                    }
                    catch (Throwable var13_27) {
                        var12_24.addSuppressed(var13_27);
                    }
                    break;
lbl100:
                    // 1 sources

                    newPath.close();
                    break;
                    catch (Throwable var13_28) {
                        try {
                            var12_24 = var13_28;
                            throw var13_28;
                        }
                        catch (Throwable var22_44) {
                            if (newPath != null) {
                                if (var12_24 != null) {
                                    try {
                                        newPath.close();
                                    }
                                    catch (Throwable var23_45) {
                                        var12_24.addSuppressed(var23_45);
                                    }
                                } else {
                                    newPath.close();
                                }
                            }
                            throw var22_44;
                        }
                    }
lbl117:
                    // 1 sources

                    throw new RemoteFileSystemConnectorException("Failed to rename file: " + path.getName().getURI() + " not found");
                }
                case 7: {
                    if (path.exists()) {
                        inputStream = path.getContent().getInputStream();
                        objectInputStream = new FileObjectInputStream(inputStream, path);
                        fileContent = new RemoteFileSystemMessage(objectInputStream);
                        this.remoteFileSystemListener.onMessage(fileContent);
                        pathClose = false;
                        break;
                    }
                    throw new RemoteFileSystemConnectorException("Failed to read file: " + path.getName().getURI() + " not found");
                }
                case 8: {
                    this.remoteFileSystemListener.onMessage(new RemoteFileSystemMessage(path.getContent().getSize()));
                    break;
                }
                case 9: {
                    fileObjects = path.getChildren();
                    childrenInfo = new HashMap<String, FileInfo>();
                    for (FileObject fileObject : fileObjects) {
                        fileInfo = new FileInfo(fileObject);
                        childrenInfo.put(fileInfo.getBaseName(), fileInfo);
                    }
                    children = new RemoteFileSystemMessage(childrenInfo);
                    this.remoteFileSystemListener.onMessage(children);
                    break;
                }
                case 10: {
                    this.remoteFileSystemListener.onMessage(new RemoteFileSystemMessage(path.isFolder()));
                    break;
                }
            }
            this.remoteFileSystemListener.done();
        }
        catch (IOException | RemoteFileSystemConnectorException e) {
            this.remoteFileSystemListener.onError(e);
        }
        finally {
            if (path != null && pathClose) {
                try {
                    path.close();
                }
                catch (FileSystemException var9_10) {}
            }
            VFSClientConnectorImpl.closeQuietly(outputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

