/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.remotefilesystem.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.message.FileInfo;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemEvent;
import org.wso2.transport.remotefilesystem.server.util.FileTransportUtils;

public class RemoteFileSystemConsumer {
    private static final Logger log = LoggerFactory.getLogger(RemoteFileSystemConsumer.class);
    private String serviceName;
    private RemoteFileSystemListener remoteFileSystemListener;
    private String listeningDirURI;
    private FileObject listeningDir;
    private String fileNamePattern = null;
    private List<String> processed = new ArrayList<String>();
    private List<String> current;
    private List<FileInfo> addedFileInfo;

    public RemoteFileSystemConsumer(String id, Map<String, String> fileProperties, RemoteFileSystemListener listener) throws RemoteFileSystemConnectorException {
        this.serviceName = id;
        this.remoteFileSystemListener = listener;
        this.validateParam(fileProperties);
        this.listeningDirURI = fileProperties.get("uri");
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileSystemOptions fso = FileTransportUtils.attachFileSystemOptions(fileProperties);
            this.listeningDir = fsManager.resolveFile(this.listeningDirURI, fso);
            FileType fileType = this.listeningDir.getType();
            if (fileType != FileType.FOLDER) {
                String errorMsg = "[" + this.serviceName + "] File system server connector is used to " + "listen to a folder. But the given path does not refer to a folder.";
                RemoteFileSystemConnectorException e = new RemoteFileSystemConnectorException(errorMsg);
                this.remoteFileSystemListener.onError(e);
                throw e;
            }
        }
        catch (FileSystemException e) {
            this.remoteFileSystemListener.onError(e);
            throw new RemoteFileSystemConnectorException("[" + this.serviceName + "] Unable to initialize " + "the connection with server.", e);
        }
        if (fileProperties.get("fileNamePattern") != null) {
            this.fileNamePattern = fileProperties.get("fileNamePattern");
        }
    }

    private void validateParam(Map<String, String> fileProperties) throws RemoteFileSystemConnectorException {
        if (fileProperties.get("uri") == null) {
            RemoteFileSystemConnectorException e = new RemoteFileSystemConnectorException("uri is a mandatory parameter for FTP transport.");
            this.remoteFileSystemListener.onError(e);
            throw e;
        }
        if (fileProperties.get("uri").trim().isEmpty()) {
            RemoteFileSystemConnectorException e = new RemoteFileSystemConnectorException("[" + this.serviceName + "] " + "uri" + " parameter cannot be empty for FTP transport.");
            this.remoteFileSystemListener.onError(e);
            throw e;
        }
    }

    public void consume() throws RemoteFileSystemConnectorException {
        block23: {
            if (log.isDebugEnabled()) {
                log.debug("Thread name: " + Thread.currentThread().getName());
                log.debug("File System Consumer hashcode: " + this.hashCode());
                log.debug("Polling for directory or file: " + FileTransportUtils.maskURLPassword(this.listeningDirURI));
            }
            try {
                this.listeningDir.refresh();
                boolean isFileExists = this.listeningDir.exists();
                boolean isFileReadable = this.listeningDir.isReadable();
                if (isFileExists && isFileReadable) {
                    FileObject[] children;
                    block22: {
                        this.current = new ArrayList<String>();
                        this.addedFileInfo = new ArrayList<FileInfo>();
                        children = null;
                        try {
                            children = this.listeningDir.getChildren();
                        }
                        catch (FileSystemException ignored) {
                            if (!log.isDebugEnabled()) break block22;
                            log.debug("[" + this.serviceName + "] The file does not exist, or is not a folder, or an error " + "has occurred when trying to list the children. File URI : " + FileTransportUtils.maskURLPassword(this.listeningDirURI), (Throwable)ignored);
                        }
                    }
                    if (children == null || children.length == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("[" + this.serviceName + "] Folder at " + FileTransportUtils.maskURLPassword(this.listeningDirURI) + " is empty.");
                        }
                        break block23;
                    }
                    this.directoryHandler(children);
                    ArrayList<String> deleted = new ArrayList<String>();
                    if (this.processed.size() != this.current.size()) {
                        Iterator<String> it = this.processed.iterator();
                        while (it.hasNext()) {
                            String fileName = it.next();
                            if (this.current.contains(fileName)) continue;
                            deleted.add(fileName);
                            it.remove();
                        }
                    }
                    try {
                        if (this.addedFileInfo.size() > 0 || deleted.size() > 0) {
                            RemoteFileSystemEvent message = new RemoteFileSystemEvent(this.addedFileInfo, deleted);
                            this.remoteFileSystemListener.onMessage(message);
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        this.remoteFileSystemListener.onError(e);
                    }
                    break block23;
                }
                this.remoteFileSystemListener.onError(new RemoteFileSystemConnectorException("[" + this.serviceName + "] Unable to access or read file or directory : " + FileTransportUtils.maskURLPassword(this.listeningDirURI) + ". Reason: " + (isFileExists ? "The file can not be read!" : "The file does not exist!")));
            }
            catch (FileSystemException e) {
                this.remoteFileSystemListener.onError(e);
                throw new RemoteFileSystemConnectorException("[" + this.serviceName + "] Unable to get details from remote server.", e);
            }
            finally {
                try {
                    if (this.listeningDir != null) {
                        this.listeningDir.close();
                    }
                }
                catch (FileSystemException e) {
                    log.warn("[" + this.serviceName + "] Could not close file at URI: " + FileTransportUtils.maskURLPassword(this.listeningDirURI), (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[" + this.serviceName + "] End : Scanning directory or file : " + FileTransportUtils.maskURLPassword(this.listeningDirURI));
        }
    }

    private void directoryHandler(FileObject[] children) throws FileSystemException {
        for (FileObject child : children) {
            if (this.fileNamePattern != null && !child.getName().getBaseName().matches(this.fileNamePattern)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("File " + this.listeningDir.getName().getFriendlyURI() + " is not processed because it did not match the specified pattern.");
                continue;
            }
            FileType childType = child.getType();
            if (childType == FileType.FOLDER) {
                FileObject[] c;
                block6: {
                    c = null;
                    try {
                        c = child.getChildren();
                    }
                    catch (FileSystemException ignored) {
                        if (!log.isDebugEnabled()) break block6;
                        log.debug("The file does not exist, or is not a folder, or an error has occurred when trying to list the children. File URI : " + FileTransportUtils.maskURLPassword(this.listeningDirURI), (Throwable)ignored);
                    }
                }
                if (c == null || c.length == 0) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Folder at " + child.getName().getFriendlyURI() + " is empty.");
                    continue;
                }
                this.directoryHandler(c);
                continue;
            }
            this.current.add(child.getName().getURI());
            this.fileHandler(child);
        }
    }

    private void fileHandler(FileObject file) throws FileSystemException {
        String path = file.getName().getURI();
        if (this.processed.contains(path)) {
            return;
        }
        FileInfo info = new FileInfo(path);
        info.setFileSize(file.getContent().getSize());
        info.setLastModifiedTime(file.getContent().getLastModifiedTime());
        this.addedFileInfo.add(info);
        this.processed.add(path);
    }
}

