/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MessageWaiter;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import com.google.pubsub.v1.TopicNames;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class Publisher {
    private static final Logger logger = Logger.getLogger(Publisher.class.getName());
    private final String topicName;
    private final BatchingSettings batchingSettings;
    private final Lock messagesBatchLock;
    private List<OutstandingPublish> messagesBatch;
    private int batchedBytes;
    private final AtomicBoolean activeAlarm;
    private final PublisherStub publisherStub;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean shutdown;
    private final List<AutoCloseable> closeables;
    private final MessageWaiter messagesWaiter;
    private ScheduledFuture<?> currentAlarmFuture;

    public static long getApiMaxRequestElementCount() {
        return 1000L;
    }

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    private Publisher(Builder builder) throws IOException {
        this.topicName = builder.topicName;
        this.batchingSettings = builder.batchingSettings;
        this.messagesBatch = new LinkedList<OutstandingPublish>();
        this.messagesBatchLock = new ReentrantLock();
        this.activeAlarm = new AtomicBoolean(false);
        this.executor = builder.executorProvider.getExecutor();
        this.closeables = builder.executorProvider.shouldAutoClose() ? Collections.singletonList(new ExecutorAsBackgroundResource(this.executor)) : Collections.emptyList();
        RetrySettings retrySettings = builder.retrySettings;
        if (retrySettings.getMaxAttempts() == 0) {
            retrySettings = retrySettings.toBuilder().setMaxAttempts(Integer.MAX_VALUE).build();
        }
        PublisherStubSettings.Builder stubSettings = (PublisherStubSettings.Builder)((PublisherStubSettings.Builder)((PublisherStubSettings.Builder)PublisherStubSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setExecutorProvider(FixedExecutorProvider.create(this.executor))).setTransportChannelProvider(builder.channelProvider);
        ((BatchingCallSettings.Builder)((BatchingCallSettings.Builder)stubSettings.publishSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.CANCELLED, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNKNOWN, StatusCode.Code.UNAVAILABLE})).setRetrySettings(retrySettings)).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(false).build());
        this.publisherStub = GrpcPublisherStub.create(stubSettings.build());
        this.shutdown = new AtomicBoolean(false);
        this.messagesWaiter = new MessageWaiter();
    }

    public TopicName getTopicName() {
        return TopicNames.parse(this.topicName);
    }

    public String getTopicNameString() {
        return this.topicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<String> publish(PubsubMessage message) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Cannot publish on a shut-down publisher.");
        }
        final int messageSize = message.getSerializedSize();
        OutstandingBatch batchToSend = null;
        SettableApiFuture<String> publishResult = SettableApiFuture.create();
        final OutstandingPublish outstandingPublish = new OutstandingPublish(publishResult, message);
        this.messagesBatchLock.lock();
        try {
            if (!this.messagesBatch.isEmpty() && this.hasBatchingBytes() && (long)(this.batchedBytes + messageSize) >= this.getMaxBatchBytes()) {
                batchToSend = new OutstandingBatch(this.messagesBatch, this.batchedBytes);
                this.messagesBatch = new LinkedList<OutstandingPublish>();
                this.batchedBytes = 0;
            }
            if (!this.hasBatchingBytes() || (long)messageSize < this.getMaxBatchBytes()) {
                this.batchedBytes += messageSize;
                this.messagesBatch.add(outstandingPublish);
                if ((long)this.messagesBatch.size() == this.getBatchingSettings().getElementCountThreshold()) {
                    batchToSend = new OutstandingBatch(this.messagesBatch, this.batchedBytes);
                    this.messagesBatch = new LinkedList<OutstandingPublish>();
                    this.batchedBytes = 0;
                }
            }
            if (!this.messagesBatch.isEmpty()) {
                this.setupDurationBasedPublishAlarm();
            } else if (this.currentAlarmFuture != null) {
                logger.log(Level.FINER, "Cancelling alarm, no more messages");
                if (this.activeAlarm.getAndSet(false)) {
                    this.currentAlarmFuture.cancel(false);
                }
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        this.messagesWaiter.incrementPendingMessages(1);
        if (batchToSend != null) {
            logger.log(Level.FINER, "Scheduling a batch for immediate sending.");
            final OutstandingBatch finalBatchToSend = batchToSend;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Publisher.this.publishOutstandingBatch(finalBatchToSend);
                }
            });
        }
        if (this.hasBatchingBytes() && (long)messageSize >= this.getMaxBatchBytes()) {
            logger.log(Level.FINER, "Message exceeds the max batch bytes, scheduling it for immediate send.");
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Publisher.this.publishOutstandingBatch(new OutstandingBatch(ImmutableList.of(outstandingPublish), messageSize));
                }
            });
        }
        return publishResult;
    }

    private void setupDurationBasedPublishAlarm() {
        if (!this.activeAlarm.getAndSet(true)) {
            long delayThresholdMs = this.getBatchingSettings().getDelayThreshold().toMillis();
            logger.log(Level.FINER, "Setting up alarm for the next {0} ms.", delayThresholdMs);
            this.currentAlarmFuture = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    logger.log(Level.FINER, "Sending messages based on schedule.");
                    Publisher.this.activeAlarm.getAndSet(false);
                    Publisher.this.publishAllOutstanding();
                }
            }, delayThresholdMs, TimeUnit.MILLISECONDS);
        }
    }

    public void publishAllOutstanding() {
        OutstandingBatch batchToSend;
        this.messagesBatchLock.lock();
        try {
            if (this.messagesBatch.isEmpty()) {
                return;
            }
            batchToSend = new OutstandingBatch(this.messagesBatch, this.batchedBytes);
            this.messagesBatch = new LinkedList<OutstandingPublish>();
            this.batchedBytes = 0;
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        this.publishOutstandingBatch(batchToSend);
    }

    private void publishOutstandingBatch(final OutstandingBatch outstandingBatch) {
        PublishRequest.Builder publishRequest = PublishRequest.newBuilder();
        publishRequest.setTopic(this.topicName);
        for (OutstandingPublish outstandingPublish : outstandingBatch.outstandingPublishes) {
            publishRequest.addMessages(outstandingPublish.message);
        }
        ApiFutures.addCallback(this.publisherStub.publishCallable().futureCall(publishRequest.build()), new ApiFutureCallback<PublishResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(PublishResponse result) {
                try {
                    if (result.getMessageIdsCount() != outstandingBatch.size()) {
                        IllegalStateException t = new IllegalStateException(String.format("The publish result count %s does not match the expected %s results. Please contact Cloud Pub/Sub support if this frequently occurs", result.getMessageIdsCount(), outstandingBatch.size()));
                        for (OutstandingPublish oustandingMessage : outstandingBatch.outstandingPublishes) {
                            oustandingMessage.publishResult.setException(t);
                        }
                        return;
                    }
                    Iterator<OutstandingPublish> messagesResultsIt = outstandingBatch.outstandingPublishes.iterator();
                    for (String messageId : result.getMessageIdsList()) {
                        messagesResultsIt.next().publishResult.set(messageId);
                    }
                }
                finally {
                    Publisher.this.messagesWaiter.incrementPendingMessages(-outstandingBatch.size());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable t) {
                try {
                    for (OutstandingPublish outstandingPublish : outstandingBatch.outstandingPublishes) {
                        outstandingPublish.publishResult.setException(t);
                    }
                }
                finally {
                    Publisher.this.messagesWaiter.incrementPendingMessages(-outstandingBatch.size());
                }
            }
        });
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingSettings;
    }

    private long getMaxBatchBytes() {
        return this.getBatchingSettings().getRequestByteThreshold();
    }

    public void shutdown() throws Exception {
        if (this.shutdown.getAndSet(true)) {
            throw new IllegalStateException("Cannot shut down a publisher already shut-down.");
        }
        if (this.currentAlarmFuture != null && this.activeAlarm.getAndSet(false)) {
            this.currentAlarmFuture.cancel(false);
        }
        this.publishAllOutstanding();
        this.messagesWaiter.waitNoMessages();
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
        this.publisherStub.shutdown();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.publisherStub.awaitTermination(duration, unit);
    }

    private boolean hasBatchingBytes() {
        return this.getMaxBatchBytes() > 0L;
    }

    public static Builder newBuilder(TopicName topicName) {
        return Publisher.newBuilder(topicName.toString());
    }

    public static Builder newBuilder(String topicName) {
        return new Builder(topicName);
    }

    public static final class Builder {
        static final Duration MIN_TOTAL_TIMEOUT = Duration.ofSeconds(10L);
        static final Duration MIN_RPC_TIMEOUT = Duration.ofMillis(10L);
        static final long DEFAULT_ELEMENT_COUNT_THRESHOLD = 100L;
        static final long DEFAULT_REQUEST_BYTES_THRESHOLD = 1000L;
        static final Duration DEFAULT_DELAY_THRESHOLD = Duration.ofMillis(1L);
        static final Duration DEFAULT_RPC_TIMEOUT = Duration.ofSeconds(10L);
        static final Duration DEFAULT_TOTAL_TIMEOUT = MIN_TOTAL_TIMEOUT;
        static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setDelayThreshold(DEFAULT_DELAY_THRESHOLD).setRequestByteThreshold(1000L).setElementCountThreshold(100L).build();
        static final RetrySettings DEFAULT_RETRY_SETTINGS = RetrySettings.newBuilder().setTotalTimeout(DEFAULT_TOTAL_TIMEOUT).setInitialRetryDelay(Duration.ofMillis(5L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis(Long.MAX_VALUE)).setInitialRpcTimeout(DEFAULT_RPC_TIMEOUT).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(DEFAULT_RPC_TIMEOUT).build();
        private static final int THREADS_PER_CPU = 5;
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();
        String topicName;
        BatchingSettings batchingSettings = DEFAULT_BATCHING_SETTINGS;
        RetrySettings retrySettings = DEFAULT_RETRY_SETTINGS;
        TransportChannelProvider channelProvider = TopicAdminSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        HeaderProvider headerProvider = new NoHeaderProvider();
        HeaderProvider internalHeaderProvider = TopicAdminSettings.defaultApiClientHeaderProviderBuilder().build();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        CredentialsProvider credentialsProvider = TopicAdminSettings.defaultCredentialsProviderBuilder().build();

        private Builder(String topic) {
            this.topicName = Preconditions.checkNotNull(topic);
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = Preconditions.checkNotNull(channelProvider);
            return this;
        }

        @BetaApi
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = Preconditions.checkNotNull(headerProvider);
            return this;
        }

        Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            this.internalHeaderProvider = Preconditions.checkNotNull(internalHeaderProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = Preconditions.checkNotNull(credentialsProvider);
            return this;
        }

        public Builder setBatchingSettings(BatchingSettings batchingSettings) {
            Preconditions.checkNotNull(batchingSettings);
            Preconditions.checkNotNull(batchingSettings.getElementCountThreshold());
            Preconditions.checkArgument(batchingSettings.getElementCountThreshold() > 0L);
            Preconditions.checkNotNull(batchingSettings.getRequestByteThreshold());
            Preconditions.checkArgument(batchingSettings.getRequestByteThreshold() > 0L);
            Preconditions.checkNotNull(batchingSettings.getDelayThreshold());
            Preconditions.checkArgument(batchingSettings.getDelayThreshold().toMillis() > 0L);
            this.batchingSettings = batchingSettings;
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            Preconditions.checkArgument(retrySettings.getTotalTimeout().compareTo(MIN_TOTAL_TIMEOUT) >= 0);
            Preconditions.checkArgument(retrySettings.getInitialRpcTimeout().compareTo(MIN_RPC_TIMEOUT) >= 0);
            this.retrySettings = retrySettings;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = Preconditions.checkNotNull(executorProvider);
            return this;
        }

        public Publisher build() throws IOException {
            return new Publisher(this);
        }
    }

    private static final class OutstandingPublish {
        SettableApiFuture<String> publishResult;
        PubsubMessage message;

        OutstandingPublish(SettableApiFuture<String> publishResult, PubsubMessage message) {
            this.publishResult = publishResult;
            this.message = message;
        }
    }

    private static final class OutstandingBatch {
        final List<OutstandingPublish> outstandingPublishes;
        final long creationTime;
        int attempt;
        int batchSizeBytes;

        OutstandingBatch(List<OutstandingPublish> outstandingPublishes, int batchSizeBytes) {
            this.outstandingPublishes = outstandingPublishes;
            this.attempt = 1;
            this.creationTime = System.currentTimeMillis();
            this.batchSizeBytes = batchSizeBytes;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public int size() {
            return this.outstandingPublishes.size();
        }
    }
}

