/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.UpdateSnapshotRequest;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SubscriberStubSettings
extends StubSettings<SubscriberStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/pubsub")).build();
    private final UnaryCallSettings<Subscription, Subscription> createSubscriptionSettings;
    private final UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
    private final UnaryCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
    private final PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
    private final UnaryCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
    private final UnaryCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
    private final UnaryCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings;
    private final UnaryCallSettings<PullRequest, PullResponse> pullSettings;
    private final StreamingCallSettings<StreamingPullRequest, StreamingPullResponse> streamingPullSettings;
    private final UnaryCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
    private final PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
    private final UnaryCallSettings<CreateSnapshotRequest, Snapshot> createSnapshotSettings;
    private final UnaryCallSettings<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings;
    private final UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
    private final UnaryCallSettings<SeekRequest, SeekResponse> seekSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> LIST_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListSubscriptionsRequest injectToken(ListSubscriptionsRequest payload, String token) {
            return ListSubscriptionsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListSubscriptionsRequest injectPageSize(ListSubscriptionsRequest payload, int pageSize) {
            return ListSubscriptionsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Subscription> extractResources(ListSubscriptionsResponse payload) {
            return payload.getSubscriptionsList() != null ? payload.getSubscriptionsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> LIST_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListSnapshotsRequest injectToken(ListSnapshotsRequest payload, String token) {
            return ListSnapshotsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListSnapshotsRequest injectPageSize(ListSnapshotsRequest payload, int pageSize) {
            return ListSnapshotsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListSnapshotsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListSnapshotsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Snapshot> extractResources(ListSnapshotsResponse payload) {
            return payload.getSnapshotsList() != null ? payload.getSnapshotsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> LIST_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse>(){

        @Override
        public ApiFuture<SubscriptionAdminClient.ListSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> callable, ListSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> pageContext = PageContext.create(callable, LIST_SUBSCRIPTIONS_PAGE_STR_DESC, request, context);
            return SubscriptionAdminClient.ListSubscriptionsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> LIST_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse>(){

        @Override
        public ApiFuture<SubscriptionAdminClient.ListSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> callable, ListSnapshotsRequest request, ApiCallContext context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> pageContext = PageContext.create(callable, LIST_SNAPSHOTS_PAGE_STR_DESC, request, context);
            return SubscriptionAdminClient.ListSnapshotsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<Subscription, Subscription> createSubscriptionSettings() {
        return this.createSubscriptionSettings;
    }

    public UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
        return this.getSubscriptionSettings;
    }

    public UnaryCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
        return this.updateSubscriptionSettings;
    }

    public PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
        return this.listSubscriptionsSettings;
    }

    public UnaryCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
        return this.deleteSubscriptionSettings;
    }

    public UnaryCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
        return this.modifyAckDeadlineSettings;
    }

    public UnaryCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings() {
        return this.acknowledgeSettings;
    }

    public UnaryCallSettings<PullRequest, PullResponse> pullSettings() {
        return this.pullSettings;
    }

    public StreamingCallSettings<StreamingPullRequest, StreamingPullResponse> streamingPullSettings() {
        return this.streamingPullSettings;
    }

    public UnaryCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
        return this.modifyPushConfigSettings;
    }

    public PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    public UnaryCallSettings<CreateSnapshotRequest, Snapshot> createSnapshotSettings() {
        return this.createSnapshotSettings;
    }

    public UnaryCallSettings<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings() {
        return this.updateSnapshotSettings;
    }

    public UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    public UnaryCallSettings<SeekRequest, SeekResponse> seekSettings() {
        return this.seekSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SubscriberStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSubscriberStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsub.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(0x1400000);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SubscriberStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SubscriberStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SubscriberStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.createSubscriptionSettings = settingsBuilder.createSubscriptionSettings().build();
        this.getSubscriptionSettings = settingsBuilder.getSubscriptionSettings().build();
        this.updateSubscriptionSettings = settingsBuilder.updateSubscriptionSettings().build();
        this.listSubscriptionsSettings = settingsBuilder.listSubscriptionsSettings().build();
        this.deleteSubscriptionSettings = settingsBuilder.deleteSubscriptionSettings().build();
        this.modifyAckDeadlineSettings = settingsBuilder.modifyAckDeadlineSettings().build();
        this.acknowledgeSettings = settingsBuilder.acknowledgeSettings().build();
        this.pullSettings = settingsBuilder.pullSettings().build();
        this.streamingPullSettings = settingsBuilder.streamingPullSettings().build();
        this.modifyPushConfigSettings = settingsBuilder.modifyPushConfigSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
        this.createSnapshotSettings = settingsBuilder.createSnapshotSettings().build();
        this.updateSnapshotSettings = settingsBuilder.updateSnapshotSettings().build();
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
        this.seekSettings = settingsBuilder.seekSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SubscriberStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings;
        private final UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
        private final UnaryCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
        private final PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
        private final UnaryCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
        private final UnaryCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
        private final UnaryCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings;
        private final UnaryCallSettings.Builder<PullRequest, PullResponse> pullSettings;
        private final StreamingCallSettings.Builder<StreamingPullRequest, StreamingPullResponse> streamingPullSettings;
        private final UnaryCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
        private final PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
        private final UnaryCallSettings.Builder<CreateSnapshotRequest, Snapshot> createSnapshotSettings;
        private final UnaryCallSettings.Builder<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings;
        private final UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
        private final UnaryCallSettings.Builder<SeekRequest, SeekResponse> seekSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSubscriptionsSettings = PagedCallSettings.newBuilder(LIST_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.deleteSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.modifyAckDeadlineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.acknowledgeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pullSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.streamingPullSettings = StreamingCallSettings.newBuilder();
            this.modifyPushConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnapshotsSettings = PagedCallSettings.newBuilder(LIST_SNAPSHOTS_PAGE_STR_FACT);
            this.createSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.seekSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.updateSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings, this.listSnapshotsSettings, this.createSnapshotSettings, this.updateSnapshotSettings, new UnaryCallSettings.Builder[]{this.deleteSnapshotSettings, this.seekSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SubscriberStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(SubscriberStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(SubscriberStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SubscriberStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSubscriptionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.getSubscriptionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.updateSubscriptionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            ((PagedCallSettings.Builder)builder.listSubscriptionsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.deleteSubscriptionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.modifyAckDeadlineSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.acknowledgeSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("messaging"));
            builder.pullSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("messaging"));
            builder.modifyPushConfigSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            ((PagedCallSettings.Builder)builder.listSnapshotsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.createSnapshotSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.updateSnapshotSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.deleteSnapshotSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.seekSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.setIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.getIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("non_idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            return builder;
        }

        protected Builder(SubscriberStubSettings settings) {
            super(settings);
            this.createSubscriptionSettings = settings.createSubscriptionSettings.toBuilder();
            this.getSubscriptionSettings = settings.getSubscriptionSettings.toBuilder();
            this.updateSubscriptionSettings = settings.updateSubscriptionSettings.toBuilder();
            this.listSubscriptionsSettings = settings.listSubscriptionsSettings.toBuilder();
            this.deleteSubscriptionSettings = settings.deleteSubscriptionSettings.toBuilder();
            this.modifyAckDeadlineSettings = settings.modifyAckDeadlineSettings.toBuilder();
            this.acknowledgeSettings = settings.acknowledgeSettings.toBuilder();
            this.pullSettings = settings.pullSettings.toBuilder();
            this.streamingPullSettings = settings.streamingPullSettings.toBuilder();
            this.modifyPushConfigSettings = settings.modifyPushConfigSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.createSnapshotSettings = settings.createSnapshotSettings.toBuilder();
            this.updateSnapshotSettings = settings.updateSnapshotSettings.toBuilder();
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.seekSettings = settings.seekSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.updateSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings, this.listSnapshotsSettings, this.createSnapshotSettings, this.updateSnapshotSettings, new UnaryCallSettings.Builder[]{this.deleteSnapshotSettings, this.seekSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings() {
            return this.createSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
            return this.getSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
            return this.updateSubscriptionSettings;
        }

        public PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
            return this.listSubscriptionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
            return this.deleteSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
            return this.modifyAckDeadlineSettings;
        }

        public UnaryCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings() {
            return this.acknowledgeSettings;
        }

        public UnaryCallSettings.Builder<PullRequest, PullResponse> pullSettings() {
            return this.pullSettings;
        }

        public StreamingCallSettings.Builder<StreamingPullRequest, StreamingPullResponse> streamingPullSettings() {
            return this.streamingPullSettings;
        }

        public UnaryCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
            return this.modifyPushConfigSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotRequest, Snapshot> createSnapshotSettings() {
            return this.createSnapshotSettings;
        }

        public UnaryCallSettings.Builder<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings() {
            return this.updateSnapshotSettings;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public UnaryCallSettings.Builder<SeekRequest, SeekResponse> seekSettings() {
            return this.seekSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public SubscriberStubSettings build() throws IOException {
            return new SubscriberStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("idempotent", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.ABORTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN)));
            definitions.put("non_idempotent", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE)));
            definitions.put("none", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(60000L)).setTotalTimeout(Duration.ofMillis(600000L)).build();
            definitions.put("default", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(12000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(12000L)).setTotalTimeout(Duration.ofMillis(600000L)).build();
            definitions.put("messaging", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(600000L)).setTotalTimeout(Duration.ofMillis(600000L)).build();
            definitions.put("streaming_messaging", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

