/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.internal.GrpcAttributes;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;

public final class GoogleDefaultProtocolNegotiator
implements ProtocolNegotiator {
    private final ProtocolNegotiator altsProtocolNegotiator;
    private final ProtocolNegotiator tlsProtocolNegotiator;

    public GoogleDefaultProtocolNegotiator(TsiHandshakerFactory altsFactory, SslContext sslContext) {
        this.altsProtocolNegotiator = AltsProtocolNegotiator.createClientNegotiator(altsFactory);
        this.tlsProtocolNegotiator = ProtocolNegotiators.tls(sslContext);
    }

    @VisibleForTesting
    GoogleDefaultProtocolNegotiator(ProtocolNegotiator altsProtocolNegotiator, ProtocolNegotiator tlsProtocolNegotiator) {
        this.altsProtocolNegotiator = altsProtocolNegotiator;
        this.tlsProtocolNegotiator = tlsProtocolNegotiator;
    }

    @Override
    public ProtocolNegotiator.Handler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
        if (grpcHandler.getEagAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) != null || grpcHandler.getEagAttributes().get(GrpcAttributes.ATTR_LB_PROVIDED_BACKEND) != null) {
            return this.altsProtocolNegotiator.newHandler(grpcHandler);
        }
        return this.tlsProtocolNegotiator.newHandler(grpcHandler);
    }

    @Override
    public void close() {
        this.altsProtocolNegotiator.close();
        this.tlsProtocolNegotiator.close();
    }
}

