/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectSnapshotName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/snapshots/{snapshot}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String snapshot;

    public String getProject() {
        return this.project;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectSnapshotName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.snapshot = Preconditions.checkNotNull(builder.getSnapshot());
    }

    public static ProjectSnapshotName of(String project, String snapshot) {
        return ProjectSnapshotName.newBuilder().setProject(project).setSnapshot(snapshot).build();
    }

    public static String format(String project, String snapshot) {
        return ProjectSnapshotName.newBuilder().setProject(project).setSnapshot(snapshot).build().toString();
    }

    public static ProjectSnapshotName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectSnapshotName.parse: formattedString not in valid format");
        return ProjectSnapshotName.of(matchMap.get("project"), matchMap.get("snapshot"));
    }

    public static List<ProjectSnapshotName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectSnapshotName> list = new ArrayList<ProjectSnapshotName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectSnapshotName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectSnapshotName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectSnapshotName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectSnapshotName projectSnapshotName = this;
            synchronized (projectSnapshotName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("snapshot", this.snapshot);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "snapshot", this.snapshot);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectSnapshotName) {
            ProjectSnapshotName that = (ProjectSnapshotName)o;
            return this.project.equals(that.project) && this.snapshot.equals(that.snapshot);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.snapshot.hashCode();
    }

    public static class Builder {
        private String project;
        private String snapshot;

        public String getProject() {
            return this.project;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectSnapshotName projectSnapshotName) {
            this.project = projectSnapshotName.project;
            this.snapshot = projectSnapshotName.snapshot;
        }

        public ProjectSnapshotName build() {
            return new ProjectSnapshotName(this);
        }
    }
}

