/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http;

import com.google.common.base.Preconditions;
import io.opencensus.contrib.http.AbstractHttpHandler;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.trace.Link;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.propagation.SpanContextParseException;
import io.opencensus.trace.propagation.TextFormat;
import javax.annotation.Nullable;

class HttpServerHandler<Q, P, C>
extends AbstractHttpHandler<Q, P> {
    private final TextFormat.Getter<C> getter;
    private final TextFormat textFormat;
    private final Tracer tracer;
    private final Boolean publicEndpoint;

    public HttpServerHandler(Tracer tracer, HttpExtractor<Q, P> extractor, TextFormat textFormat, TextFormat.Getter<C> getter, Boolean publicEndpoint) {
        super(extractor);
        Preconditions.checkNotNull(tracer, "tracer");
        Preconditions.checkNotNull(textFormat, "textFormat");
        Preconditions.checkNotNull(getter, "getter");
        Preconditions.checkNotNull(publicEndpoint, "publicEndpoint");
        this.tracer = tracer;
        this.textFormat = textFormat;
        this.getter = getter;
        this.publicEndpoint = publicEndpoint;
    }

    public Span handleStart(C carrier, Q request) {
        Preconditions.checkNotNull(carrier, "carrier");
        Preconditions.checkNotNull(request, "request");
        SpanBuilder spanBuilder = null;
        String spanName = this.getSpanName(request, this.extractor);
        SpanContext spanContext = null;
        try {
            spanContext = this.textFormat.extract(carrier, this.getter);
        }
        catch (SpanContextParseException spanContextParseException) {
            // empty catch block
        }
        spanBuilder = spanContext == null || this.publicEndpoint != false ? this.tracer.spanBuilder(spanName) : this.tracer.spanBuilderWithRemoteParent(spanName, spanContext);
        Span span = spanBuilder.startSpan();
        if (this.publicEndpoint.booleanValue() && spanContext != null) {
            span.addLink(Link.fromSpanContext(spanContext, Link.Type.PARENT_LINKED_SPAN));
        }
        return span;
    }

    public void handleEnd(Span span, @Nullable P response, @Nullable Throwable error) {
        this.spanEnd(span, response, error);
    }
}

