/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.googlepubsub.source;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.pubsub.v1.PubsubMessage;
import io.siddhi.core.stream.input.source.SourceEventListener;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class GooglePubSubMessageReceiver
implements MessageReceiver {
    private SourceEventListener sourceEventListener;
    private boolean paused;
    private ReentrantLock lock;
    private Condition condition;

    public GooglePubSubMessageReceiver(SourceEventListener sourceEventListener) {
        this.sourceEventListener = sourceEventListener;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(PubsubMessage pubsubMessage, AckReplyConsumer ackReplyConsumer) {
        if (this.paused) {
            this.lock.lock();
            try {
                this.condition.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
        ackReplyConsumer.ack();
        this.sourceEventListener.onEvent((Object)("message :'" + pubsubMessage.getData().toStringUtf8() + "'"), null);
    }

    void pause() {
        this.paused = true;
    }

    void resume() {
        this.paused = false;
        try {
            this.lock.lock();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

