/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.sink;

import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.StreamObserver;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.sink.AbstractGrpcSink;
import io.siddhi.extension.io.grpc.util.GrpcUtils;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.grpc.Event;
import org.wso2.grpc.EventServiceGrpc;

@Extension(name="grpc", namespace="sink", description="This extension publishes event data encoded into GRPC Classes as defined in the user input jar. This extension has a default gRPC service classes added. The default service is called \"EventService\". Please find the protobuf definition [here](https://github.com/siddhi-io/siddhi-io-grpc/tree/master/component/src/main/resources/EventService.proto). This grpc sink is used for scenarios where we send a request and don't expect a response back. I.e getting a google.protobuf.Empty response back.", parameters={@Parameter(name="publisher.url", description="The url to which the outgoing events should be published via this extension. This url should consist the host address, port, service name, method name in the following format. `grpc://0.0.0.0:9763/<serviceName>/<methodName>`", type={DataType.STRING}), @Parameter(name="headers", description="GRPC Request headers in format `\"'<key>:<value>','<key>:<value>'\"`. If header parameter is not provided just the payload is sent", type={DataType.STRING}, optional=true, defaultValue="-"), @Parameter(name="idle.timeout", description="Set the duration in seconds without ongoing RPCs before going to idle mode.", type={DataType.LONG}, optional=true, defaultValue="1800"), @Parameter(name="keep.alive.time", description="Sets the time in seconds without read activity before sending a keepalive ping. Keepalives can increase the load on services so must be used with caution. By default set to Long.MAX_VALUE which disables keep alive pinging.", type={DataType.LONG}, optional=true, defaultValue="Long.MAX_VALUE"), @Parameter(name="keep.alive.timeout", description="Sets the time in seconds waiting for read activity after sending a keepalive ping.", type={DataType.LONG}, optional=true, defaultValue="20"), @Parameter(name="keep.alive.without.calls", description="Sets whether keepalive will be performed when there are no outstanding RPC on a connection.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="enable.retry", description="Enables the retry mechanism provided by the gRPC library.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="max.retry.attempts", description="Sets max number of retry attempts. The total number of retry attempts for each RPC will not exceed this number even if service config may allow a higher number.", type={DataType.INT}, optional=true, defaultValue="5"), @Parameter(name="retry.buffer.size", description="Sets the retry buffer size in bytes. If the buffer limit is exceeded, no RPC could retry at the moment, and in hedging case all hedges but one of the same RPC will cancel.", type={DataType.LONG}, optional=true, defaultValue="16777216"), @Parameter(name="per.rpc.buffer.size", description="Sets the per RPC buffer limit in bytes used for retry. The RPC is not retriable if its buffer limit is exceeded.", type={DataType.LONG}, optional=true, defaultValue="1048576"), @Parameter(name="channel.termination.waiting.time", description="The time in seconds to wait for the channel to become terminated, giving up if the timeout is reached.", type={DataType.LONG}, optional=true, defaultValue="5"), @Parameter(name="truststore.file", description="the file path of truststore. If this is provided then server authentication is enabled", type={DataType.STRING}, optional=true, defaultValue="-"), @Parameter(name="truststore.password", description="the password of truststore. If this is provided then the integrity of the keystore is checked", type={DataType.STRING}, optional=true, defaultValue="-"), @Parameter(name="truststore.algorithm", description="the encryption algorithm to be used for server authentication", type={DataType.STRING}, optional=true, defaultValue="-"), @Parameter(name="tls.store.type", description="TLS store type", type={DataType.STRING}, optional=true, defaultValue="-"), @Parameter(name="keystore.file", description="the file path of keystore. If this is provided then client authentication is enabled", type={DataType.STRING}, optional=true, defaultValue="-"), @Parameter(name="keystore.password", description="the password of keystore", type={DataType.STRING}, optional=true, defaultValue="-"), @Parameter(name="keystore.algorithm", description="the encryption algorithm to be used for client authentication", type={DataType.STRING}, optional=true, defaultValue="-")}, examples={@Example(syntax="@sink(type='grpc',\n      publisher.url = 'grpc://134.23.43.35:8080/org.wso2.grpc.EventService/consume',\n      @map(type='json'))\ndefine stream FooStream (message String);", description="Here a stream named FooStream is defined with grpc sink. A grpc server should be running at 194.23.98.100 listening to port 8080. sink.id is set to 1 here. So we can write a source with sink.id 1 so that it will listen to responses for requests published from this stream. Note that since we are using EventService/consume the sink will be operating in default mode"), @Example(syntax="@sink(type='grpc',\n      publisher.url = 'grpc://134.23.43.35:8080/org.wso2.grpc.EventService/consume',\n      headers='{{headers}}',\n      @map(type='json'),\n           @payload('{{message}}'))\ndefine stream FooStream (message String, headers String);", description="A similar example to above but with headers. Headers are also send into the stream as a data. In the sink headers dynamic property reads the value and sends it as MetaData with the request"), @Example(syntax="@sink(type='grpc',\n      publisher.url = 'grpc://134.23.43.35:8080/org.wso2.grpc.test.MyService/send',\n      @map(type='protobuf'),\ndefine stream FooStream (stringValue string, intValue int,longValue long,booleanValue bool,floatValue float,doubleValue double);", description="Here a stream named FooStream is defined with grpc sink.A grpc servershould be running at 194.23.98.100 listening to port 8080, since there is no mapper provided, attributes of stream definition should be same as the attributes of protobuf message definition")})
public class GrpcSink
extends AbstractGrpcSink {
    private static final Logger logger = Logger.getLogger((String)GrpcSink.class.getName());
    private AbstractStub asyncStub;

    @Override
    public void initSink(OptionHolder optionHolder) {
        if (this.isDefaultMode) {
            if (this.methodName == null) {
                this.methodName = "consume";
            } else if (!this.methodName.equalsIgnoreCase("consume")) {
                throw new SiddhiAppValidationException(this.siddhiAppName + ": " + this.streamID + ": In default mode grpc-sink when using EventService the method name should be '" + "consume" + "' but given " + this.methodName);
            }
        }
    }

    public void publish(Object payload, DynamicOptions dynamicOptions, State state) throws ConnectionUnavailableException {
        StreamObserver<Empty> responseObserver = new StreamObserver<Empty>(){

            public void onNext(Empty event) {
            }

            public void onError(Throwable t) {
                logger.error((Object)(GrpcSink.this.siddhiAppName + ":" + GrpcSink.this.streamID + ": " + t.getMessage() + " caused by " + t.getCause()));
            }

            public void onCompleted() {
            }
        };
        if (this.isDefaultMode) {
            Event.Builder eventBuilder = Event.newBuilder().setPayload(payload.toString());
            EventServiceGrpc.EventServiceStub currentAsyncStub = (EventServiceGrpc.EventServiceStub)this.asyncStub;
            if (this.headersOption != null || this.sequenceName != null) {
                eventBuilder = this.addHeadersToEventBuilder(dynamicOptions, eventBuilder);
            }
            if (this.metadataOption != null) {
                currentAsyncStub = (EventServiceGrpc.EventServiceStub)this.attachMetaDataToStub(dynamicOptions, currentAsyncStub);
            }
            currentAsyncStub.consume(eventBuilder.build(), responseObserver);
        } else {
            try {
                AbstractStub currentAsyncStubObject = this.asyncStub;
                if (this.metadataOption != null) {
                    currentAsyncStubObject = this.attachMetaDataToStub(dynamicOptions, currentAsyncStubObject);
                }
                Class[] parameterTypes = new Class[]{this.requestClass, StreamObserver.class};
                Object[] arguments = new Object[]{payload, responseObserver};
                Method rpcMethod = this.asyncStub.getClass().getDeclaredMethod(this.methodName, parameterTypes);
                rpcMethod.invoke((Object)currentAsyncStubObject, arguments);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new SiddhiAppCreationException(this.siddhiAppName + ": Invalid method name provided in the url, provided method name : '" + this.methodName + "' expected one of these methods : " + GrpcUtils.getRPCmethodList(this.serviceReference, this.siddhiAppName) + ". " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void connect() throws ConnectionUnavailableException {
        this.channel = this.managedChannelBuilder.build();
        if (this.isDefaultMode) {
            this.asyncStub = EventServiceGrpc.newStub((Channel)this.channel);
        } else {
            String serviceClassName = this.serviceReference + "Grpc";
            try {
                Class<?> serviceClass = Class.forName(serviceClassName);
                Method newStub = serviceClass.getDeclaredMethod("newStub", Channel.class);
                this.asyncStub = (AbstractStub)newStub.invoke(serviceClass, this.channel);
            }
            catch (ClassNotFoundException e) {
                throw new SiddhiAppCreationException(this.siddhiAppName + ": Invalid service name provided in the url, provided service name : '" + this.serviceReference + "'. " + e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new SiddhiAppCreationException(this.siddhiAppName + ": Invalid method name provided in the url, provided method name : '" + this.methodName + "' expected one of these methods : " + GrpcUtils.getRPCmethodList(this.serviceReference, this.siddhiAppName) + ". " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.channel.isShutdown()) {
            throw new ConnectionUnavailableException(this.siddhiAppName + ": gRPC service on" + this.streamID + " could not connect to " + this.url);
        }
        logger.info((Object)(this.siddhiAppName + ": gRPC service on " + this.streamID + " has successfully connected to " + this.url));
    }

    public void disconnect() {
        try {
            if (this.channelTerminationWaitingTimeInMillis > 0L) {
                this.channel.shutdown().awaitTermination(this.channelTerminationWaitingTimeInMillis, TimeUnit.MILLISECONDS);
            } else {
                this.channel.shutdown();
            }
            this.channel = null;
        }
        catch (InterruptedException e) {
            logger.error((Object)(this.siddhiAppName + ": " + this.streamID + ": Error in shutting down the channel. " + e.getMessage()), (Throwable)e);
        }
    }
}

