/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.source;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.util.GrpcUtils;
import io.siddhi.extension.io.grpc.util.SourceServerInterceptor;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public abstract class AbstractGrpcSource
extends Source {
    public static ThreadLocal<Map<String, String>> metaDataMap = new ThreadLocal();
    protected SiddhiAppContext siddhiAppContext;
    protected SourceEventListener sourceEventListener;
    protected String serviceName;
    protected boolean isDefaultMode;
    protected SourceServerInterceptor serverInterceptor;
    protected NettyServerBuilder serverBuilder;
    protected long serverShutdownWaitingTimeInMillis = -1L;
    protected String streamID;
    protected Class requestClass;
    protected String methodName;
    protected String serviceReference;
    private String url;
    private int port;
    private ServiceDeploymentInfo serviceDeploymentInfo;

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return this.serviceDeploymentInfo;
    }

    public StateFactory init(SourceEventListener sourceEventListener, OptionHolder optionHolder, String[] requestedTransportPropertyNames, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        URL aURL;
        this.streamID = sourceEventListener.getStreamDefinition().getId();
        this.siddhiAppContext = siddhiAppContext;
        this.sourceEventListener = sourceEventListener;
        if (optionHolder.isOptionExists("server.shutdown.waiting.time")) {
            this.serverShutdownWaitingTimeInMillis = Long.parseLong(optionHolder.validateAndGetOption("server.shutdown.waiting.time").getValue());
        }
        this.url = optionHolder.validateAndGetOption("receiver.url").getValue();
        if (!this.url.startsWith("grpc")) {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ":" + this.streamID + ": The url must begin with \"" + "grpc" + "\" for all grpc sinks");
        }
        try {
            aURL = new URL("http" + this.url.substring(4));
        }
        catch (MalformedURLException e) {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ":" + this.streamID + ": Error in URL format. Expected format is `grpc://0.0.0.0:9763/<serviceName>/<methodName>` but the provided url is " + this.url + ". " + e.getMessage(), (Throwable)e);
        }
        this.serviceName = GrpcUtils.getServiceName(aURL.getPath());
        this.port = aURL.getPort();
        this.initSource(optionHolder, requestedTransportPropertyNames);
        this.serverInterceptor = new SourceServerInterceptor(siddhiAppContext, this.streamID);
        String truststoreFilePath = null;
        String truststorePassword = null;
        String keystoreFilePath = null;
        String keystorePassword = null;
        String truststoreAlgorithm = null;
        String keystoreAlgorithm = null;
        String tlsStoreType = null;
        if (optionHolder.isOptionExists("keystore.file")) {
            keystoreFilePath = optionHolder.validateAndGetOption("keystore.file").getValue();
            keystorePassword = optionHolder.validateAndGetOption("keystore.password").getValue();
            keystoreAlgorithm = optionHolder.validateAndGetOption("keystore.algorithm").getValue();
            tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        }
        if (optionHolder.isOptionExists("truststore.file")) {
            if (!optionHolder.isOptionExists("keystore.file")) {
                throw new SiddhiAppCreationException(siddhiAppContext.getName() + ":" + this.streamID + ": Truststore configurations given without keystore configurations. Please provide keystore");
            }
            truststoreFilePath = optionHolder.validateAndGetOption("truststore.file").getValue();
            if (optionHolder.isOptionExists("truststore.password")) {
                truststorePassword = optionHolder.validateAndGetOption("truststore.password").getValue();
            }
            truststoreAlgorithm = optionHolder.validateAndGetOption("truststore.algorithm").getValue();
            tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        }
        this.serverBuilder = NettyServerBuilder.forPort((int)this.port);
        if (keystoreFilePath != null) {
            try {
                SslContextBuilder sslContextBuilder = this.getSslContextBuilder(keystoreFilePath, keystorePassword, keystoreAlgorithm, tlsStoreType);
                if (truststoreFilePath != null) {
                    sslContextBuilder = this.addTrustStore(truststoreFilePath, truststorePassword, truststoreAlgorithm, sslContextBuilder, tlsStoreType).clientAuth(ClientAuth.REQUIRE);
                }
                this.serverBuilder.sslContext(sslContextBuilder.build());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new SiddhiAppCreationException(siddhiAppContext.getName() + ": " + this.streamID + ": Error while creating SslContext. " + e.getMessage(), (Throwable)e);
            }
        }
        this.serverBuilder.maxInboundMessageSize(Integer.parseInt(optionHolder.getOrCreateOption("max.inbound.message.size", "4194304").getValue()));
        this.serverBuilder.maxInboundMetadataSize(Integer.parseInt(optionHolder.getOrCreateOption("max.inbound.metadata.size", "8192").getValue()));
        if (this.serviceName.equals("EventService")) {
            this.isDefaultMode = true;
            this.initializeGrpcServer(this.port);
        } else {
            this.serviceReference = GrpcUtils.getFullServiceName(aURL.getPath());
            this.methodName = GrpcUtils.getMethodName(aURL.getPath());
            String[] serviceReferenceArray = this.serviceReference.split("\\.");
            this.serviceName = serviceReferenceArray[serviceReferenceArray.length - 1];
            this.initializeGrpcServer(this.port);
            try {
                this.requestClass = GrpcUtils.getRequestClass(this.serviceReference, this.methodName);
            }
            catch (ClassNotFoundException e) {
                throw new SiddhiAppCreationException(siddhiAppContext.getName() + ": Invalid service name provided in the url, provided service name : '" + this.serviceReference + "'. " + e.getMessage(), (Throwable)e);
            }
        }
        this.serviceDeploymentInfo = new ServiceDeploymentInfo(this.port, false);
        return null;
    }

    private SslContextBuilder getSslContextBuilder(String filePath, String password, String algorithm, String storeType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        char[] passphrase = password.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream fis = new FileInputStream(filePath);){
            keyStore.load(fis, passphrase);
        }
        catch (IOException e) {
            throw new SiddhiAppCreationException(this.siddhiAppContext.getName() + ": " + this.streamID + ": " + e.getMessage(), (Throwable)e);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(keyStore, passphrase);
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
        sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
        return sslContextBuilder;
    }

    private SslContextBuilder addTrustStore(String filePath, String password, String algorithm, SslContextBuilder sslContextBuilder, String storeType) throws NoSuchAlgorithmException, KeyStoreException, CertificateException {
        char[] passphrase = password.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream fis = new FileInputStream(filePath);){
            keyStore.load(fis, passphrase);
        }
        catch (IOException e) {
            throw new SiddhiAppCreationException(this.siddhiAppContext.getName() + ": " + this.streamID + ": " + e.getMessage(), (Throwable)e);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(keyStore);
        return sslContextBuilder.trustManager(tmf).clientAuth(ClientAuth.REQUIRE);
    }

    public abstract void initializeGrpcServer(int var1);

    public abstract void initSource(OptionHolder var1, String[] var2);

    public Class[] getOutputEventClasses() {
        return new Class[]{String.class, GeneratedMessageV3.class};
    }

    public void destroy() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void connectGrpcServer(Server server, Logger logger, Source.ConnectionCallback connectionCallback) {
        try {
            server.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.siddhiAppContext.getName() + ":" + this.streamID + ": gRPC Server started"));
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof BindException) {
                throw new SiddhiAppValidationException(this.siddhiAppContext.getName() + ":" + this.streamID + ": Another server is already running on the port " + this.port + ". Please provide a different port");
            }
            connectionCallback.onError(new ConnectionUnavailableException(this.siddhiAppContext.getName() + ":" + this.streamID + ": Error when starting the server. " + e.getMessage(), (Throwable)e));
            throw new SiddhiAppRuntimeException(this.siddhiAppContext.getName() + ": " + this.streamID + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void disconnectGrpcServer(Server server, Logger logger) {
        try {
            if (server == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.siddhiAppContext.getName() + ":" + this.streamID + ": Illegal state. Server already stopped."));
                }
                return;
            }
            server.shutdown();
            if (this.serverShutdownWaitingTimeInMillis != -1L) {
                if (server.awaitTermination(this.serverShutdownWaitingTimeInMillis, TimeUnit.MILLISECONDS)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.siddhiAppContext.getName() + ": " + this.streamID + ": Server stopped"));
                    }
                    return;
                }
                server.shutdownNow();
                if (server.awaitTermination(this.serverShutdownWaitingTimeInMillis, TimeUnit.SECONDS)) {
                    return;
                }
                throw new SiddhiAppRuntimeException(this.siddhiAppContext.getName() + ":" + this.streamID + ": Unable to shutdown server");
            }
        }
        catch (InterruptedException e) {
            throw new SiddhiAppRuntimeException(this.siddhiAppContext.getName() + ": " + this.streamID + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

