/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.source;

import com.google.protobuf.GeneratedMessageV3;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.util.GrpcSourceRegistry;
import java.util.Map;
import org.wso2.grpc.Event;

@Extension(name="grpc-call-response", namespace="source", description="This grpc source receives responses received from gRPC server for requests sent from a grpc-call sink. The source will receive responses for sink with the same sink.id. For example if you have a gRPC sink with sink.id 15 then we need to set the sink.id as 15 in the source to receives responses. Sinks and sources have 1:1 mapping", parameters={@Parameter(name="sink.id", description="a unique ID that should be set for each grpc-call source. There is a 1:1 mapping between grpc-call sinks and grpc-call-response sources. Each sink has one particular source listening to the responses to requests published from that sink. So the same sink.id should be given when writing the sink also.", type={DataType.INT})}, examples={@Example(syntax="@source(type='grpc-call-response', sink.id= '1')\ndefine stream BarStream (message String);", description="Here we are listening to responses  for requests sent from the sink with sink.id 1 will be received here. The results will be injected into BarStream")})
public class GrpcCallResponseSource
extends Source {
    private String sinkID;
    private SourceEventListener sourceEventListener;
    private String[] requestedTransportPropertyNames;

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return null;
    }

    public StateFactory init(SourceEventListener sourceEventListener, OptionHolder optionHolder, String[] requestedTransportPropertyNames, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.sourceEventListener = sourceEventListener;
        this.requestedTransportPropertyNames = (String[])requestedTransportPropertyNames.clone();
        this.sinkID = optionHolder.validateAndGetOption("sink.id").getValue();
        GrpcSourceRegistry.getInstance().putGrpcCallResponseSource(this.sinkID, this);
        return null;
    }

    public void onResponse(Event response, Map<String, String> siddhiRequestEventData) {
        this.sourceEventListener.onEvent((Object)response.getPayload(), this.getTransportProperties(response.getHeadersMap(), siddhiRequestEventData));
    }

    public void onResponse(Object response, Map<String, String> siddhiRequestEventData) {
        this.sourceEventListener.onEvent(response, this.getTransportProperties(siddhiRequestEventData));
    }

    private String[] getTransportProperties(Map<String, String> headersMap, Map<String, String> siddhiRequestEventData) {
        siddhiRequestEventData.putAll(headersMap);
        String[] transportProperties = new String[this.requestedTransportPropertyNames.length];
        for (int i = 0; i < this.requestedTransportPropertyNames.length; ++i) {
            if (!siddhiRequestEventData.containsKey(this.requestedTransportPropertyNames[i])) continue;
            transportProperties[i] = siddhiRequestEventData.get(this.requestedTransportPropertyNames[i]);
        }
        return transportProperties;
    }

    private String[] getTransportProperties(Map<String, String> siddhiRequestEventData) {
        String[] transportProperties = new String[this.requestedTransportPropertyNames.length];
        for (int i = 0; i < this.requestedTransportPropertyNames.length; ++i) {
            if (!siddhiRequestEventData.containsKey(this.requestedTransportPropertyNames[i])) continue;
            transportProperties[i] = siddhiRequestEventData.get(this.requestedTransportPropertyNames[i]);
        }
        return transportProperties;
    }

    public Class[] getOutputEventClasses() {
        return new Class[]{String.class, GeneratedMessageV3.class};
    }

    public void connect(Source.ConnectionCallback connectionCallback, State state) throws ConnectionUnavailableException {
    }

    public void disconnect() {
    }

    public void destroy() {
        GrpcSourceRegistry.getInstance().removeGrpcCallResponseSource(this.sinkID);
    }

    public void pause() {
    }

    public void resume() {
    }
}

