/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GrpcUtils {
    public static String getServiceName(String path) {
        ArrayList<String> urlParts = new ArrayList<String>(Arrays.asList(path.substring(1).split("/")));
        if (urlParts.contains("")) {
            throw new SiddhiAppValidationException("Malformed URL. There should not be any empty parts in the URL between two '/'");
        }
        if (urlParts.size() < 2) {
            throw new SiddhiAppValidationException("Malformed URL. After port number at least two sections should be available separated by '/' as in 'grpc://<host>:<port>/<ServiceName>/<MethodName>'");
        }
        String[] fullyQualifiedServiceNameParts = ((String)urlParts.get(0)).split("\\.");
        return fullyQualifiedServiceNameParts[fullyQualifiedServiceNameParts.length - 1];
    }

    public static String getMethodName(String path) {
        ArrayList<String> urlParts = new ArrayList<String>(Arrays.asList(path.split("/")));
        urlParts.removeAll(Collections.singletonList(""));
        if (urlParts.size() < 1) {
            return null;
        }
        return (String)urlParts.get(1);
    }

    public static String getSequenceName(String path) {
        ArrayList<String> urlParts = new ArrayList<String>(Arrays.asList(path.split("/")));
        urlParts.removeAll(Collections.singletonList(""));
        return (String)urlParts.get(2);
    }

    public static boolean isSequenceNamePresent(String path) {
        ArrayList<String> urlParts = new ArrayList<String>(Arrays.asList(path.split("/")));
        urlParts.removeAll(Collections.singletonList(""));
        return urlParts.size() == 3;
    }

    public static String[] extractHeaders(Map<String, String> headersMap, Map<String, String> metaDataMap, String[] requestedTransportPropertyNames) {
        String[] headersArray = new String[requestedTransportPropertyNames.length];
        for (int i = 0; i < requestedTransportPropertyNames.length; ++i) {
            if (headersMap.containsKey(requestedTransportPropertyNames[i])) {
                headersArray[i] = headersMap.get(requestedTransportPropertyNames[i]);
            }
            if (metaDataMap == null || !metaDataMap.containsKey(requestedTransportPropertyNames[i])) continue;
            headersArray[i] = metaDataMap.get(requestedTransportPropertyNames[i]);
        }
        List<String> headersArrayList = Arrays.asList(headersArray);
        if (headersArrayList.contains(null)) {
            throw new SiddhiAppRuntimeException("Requested transport property '" + requestedTransportPropertyNames[headersArrayList.indexOf(null)] + "' not present in received event");
        }
        return headersArray;
    }

    public static String getFullServiceName(String path) {
        ArrayList<String> urlParts = new ArrayList<String>(Arrays.asList(path.substring(1).split("/")));
        if (urlParts.contains("")) {
            throw new SiddhiAppValidationException("Malformed URL. There should not be any empty parts in the URL between two '/'");
        }
        if (urlParts.size() < 2) {
            throw new SiddhiAppValidationException("Malformed URL. After port number at least two sections should be available separated by '/' as in 'grpc://<host>:<port>/<ServiceName>/<MethodName>'");
        }
        return (String)urlParts.get(0);
    }

    public static Class getRequestClass(String serviceNameWithPackgName, String methodName) throws ClassNotFoundException {
        Method[] methods;
        String[] serviceNameWithPackgNameArray = serviceNameWithPackgName.split("\\.");
        String stubName = serviceNameWithPackgNameArray[serviceNameWithPackgNameArray.length - 1] + "BlockingStub";
        for (Method m : methods = Class.forName(serviceNameWithPackgName + "Grpc$" + stubName).getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public static Class getResponseClass(String serviceNameWithPackgName) throws ClassNotFoundException {
        Method[] methods;
        String stubName = GrpcUtils.getServiceName(serviceNameWithPackgName) + "BlockingStub";
        for (Method m : methods = Class.forName(serviceNameWithPackgName + "Grpc$" + stubName).getMethods()) {
            if (!m.getName().equals(GrpcUtils.getMethodName(serviceNameWithPackgName))) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public static List<String> getRPCmethodList(String serviceReference, String siddhiAppName) {
        Method[] methodsInBlockingStub;
        ArrayList<String> rpcMethodNameList = new ArrayList<String>();
        String blockingStubReference = serviceReference + "Grpc" + "$" + serviceReference + "BlockingStub";
        String[] serviceReferenceArray = serviceReference.split("\\.");
        String serviceName = serviceReferenceArray[serviceReference.length() - 1];
        try {
            methodsInBlockingStub = Class.forName(blockingStubReference).getMethods();
        }
        catch (ClassNotFoundException e) {
            throw new SiddhiAppCreationException(siddhiAppName + ": Invalid service name provided in url, provided service name : '" + serviceName + "'", (Throwable)e);
        }
        for (Method method : methodsInBlockingStub) {
            if (!method.getDeclaringClass().getName().equals(blockingStubReference)) continue;
            rpcMethodNameList.add(method.getName());
        }
        return rpcMethodNameList;
    }
}

